/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_14;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMaxHitsPerFileCheck;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="18.1.33")
@CheckID(value="SVTB.1.1.14")
@CheckName(value="SVTB.1.1.14")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Consecutive blank lines are not allowed.")
@CheckDescription(value="Consecutive blank lines are not allowed. Lines with only whitespaces are considered to be blank.\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", defaultValue="1"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_1_14.class)
public class Check_SVTB_1_1_14
extends AbstractMaxHitsPerFileCheck {
    @CheckParameter(defaultValue="1", description="Maximum number of blank lines.", name="maxNofLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    public int pMaxNofLines;

    public Check_SVTB_1_1_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMaxNofLines < 0) {
            this.signalParamError("'maxNofLines' is less than 0!", false);
            return;
        }
        List<ParserPath> filePaths = this.fOVMProject.getAllFilesInOrder();
        if (filePaths == null || filePaths.isEmpty()) {
            return;
        }
        HashSet<ParserPath> checkedFiles = new HashSet<ParserPath>();
        for (ParserPath path : filePaths) {
            try {
                RfFileDef filedef;
                if (checkedFiles.contains(path)) continue;
                checkedFiles.add(path);
                if (this.checkPreWaivers(path) || path.path.indexOf("__vlog__") != -1 || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(path)) == null) continue;
                this.notifyCheckAlive();
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(path.path));){
                    String lineContent = null;
                    int consecutiveBlankLines = 0;
                    int line = 0;
                    int hitsPerFile = 0;
                    while ((lineContent = reader.readLine()) != null) {
                        ++line;
                        if (this.reachedMaxHitCountInFile(hitsPerFile)) break;
                        if (lineContent.trim().isEmpty()) {
                            ++consecutiveBlankLines;
                        }
                        if (consecutiveBlankLines > this.pMaxNofLines && !lineContent.trim().isEmpty()) {
                            OVMComplianceHit hit = this.addHit(path, line - 1, String.valueOf(consecutiveBlankLines) + " blank lines found!", null, false, null, this.isHidden(hitsPerFile));
                            if (hit != null) {
                                ++hitsPerFile;
                            }
                            consecutiveBlankLines = 0;
                        }
                        if (lineContent.trim().isEmpty() || consecutiveBlankLines == 0) continue;
                        consecutiveBlankLines = 0;
                    }
                    if (this.reachedMaxHitCountInFile(hitsPerFile) || consecutiveBlankLines <= this.pMaxNofLines) continue;
                    this.addHit(path, line, String.valueOf(consecutiveBlankLines) + " blank lines found!", null, false, null, this.isHidden(hitsPerFile));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

