/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_15;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMaxHitsPerFileCheck;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="18.1.33")
@CheckID(value="SVTB.1.1.15")
@CheckName(value="SVTB.1.1.15")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Lines with only whitespaces are not allowed.")
@CheckDescription(value="Lines with only whitespaces are not allowed.\n\nExamples:\n        // not allowed\nwire a; // allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", defaultValue="1"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_1_15.class)
public class Check_SVTB_1_1_15
extends AbstractMaxHitsPerFileCheck {
    public Check_SVTB_1_1_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> allFiles = this.fOVMProject.getAllFilesInOrder();
        if (allFiles == null || allFiles.isEmpty()) {
            return;
        }
        HashSet<ParserPath> checkedFiles = new HashSet<ParserPath>();
        block7: for (ParserPath path : allFiles) {
            try {
                RfFileDef fileDef;
                if (checkedFiles.contains(path)) continue;
                checkedFiles.add(path);
                if (this.checkPreWaivers(path) || path.path.indexOf("__vlog__") != -1 || (fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(path)) == null) continue;
                this.notifyCheckAlive();
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(path.path));){
                    String lineContent = null;
                    int line = 0;
                    int hitsPerFile = 0;
                    while ((lineContent = reader.readLine()) != null) {
                        OVMComplianceHit hit;
                        ++line;
                        if (this.reachedMaxHitCountInFile(hitsPerFile)) {
                            continue block7;
                        }
                        if (lineContent.isEmpty() || !lineContent.trim().isEmpty() || (hit = this.addHit(path, line, "Line with only whitespaces found!", null, false, null, this.isHidden(hitsPerFile))) == null) continue;
                        ++hitsPerFile;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

