/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_16;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="19.1.48")
@CheckID(value="SVTB.1.1.16")
@CheckName(value="SVTB.1.1.16")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.NAME, RuleLabel.INDENTATION, RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.PORT})
@CheckTitle(value="Named port connections indentation")
@CheckDescription(value="This check verifies that the named port connections have an indentation of 'nofSpaces' relative to the module instantiation.\nThe indentation must be relative to the indentation of the line containing the opening parenthesis for the port connection list.\n\nExamples for nofSpaces = 2 :\nmodule test_module_1;\n test_module t(.a(a), .b(b), .c(c)); // not allowed\nendmodule\n\nmodule test_module_2;\ntest_module t( // allowed\n  .a(a),\n  .b(b),\n  .c(c));\nendmodule\n\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_16.class)
public class Check_SVTB_1_1_16
extends AbstractFormattingDisabledCheck {
    public static final String AUTOFIX_UNAVAILABLE_MESSAGE = "pEndingParanthesesOnDifferentLine is True";
    public static final String AUTOFIX_UNAVAILABLE_MESSAGE2 = "pCheckSpaceAfterInstanceName is True";
    private ContentReader contentReader = new ContentReader();
    @CheckParameter(defaultValue="2", description="Number of spaces used as indentation relative to the module instantiation.", name="nofSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNofSpaces;
    @CheckParameter(defaultValue="false", description="When true, allows connections on the same line.", name="allowConnectionsOnTheSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowConnectionsOnTheSameLine;
    @CheckParameter(defaultValue="false", description="When true, ending paranthesis must be alone on a separate line.", name="endingParanthesisOnDifferentLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pEndingParanthesisOnDifferentLine;
    @CheckParameter(defaultValue="false", description="When true, flags the instance name if it is not spaced from the opening paranthesis of the port connections list.", name="checkSpaceAfterInstanceName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckSpaceAfterInstanceName;

    public Check_SVTB_1_1_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.contentReader.clear();
        final HashMap<RfInstanceDef, List<RfHidOperator>> portsByInstance = new HashMap<RfInstanceDef, List<RfHidOperator>>();
        final HashMap<ParserPath, Set<RfInstanceDef>> instanceDefByParserPath = new HashMap<ParserPath, Set<RfInstanceDef>>();
        this.fOVMProject.getRfProject().accept(instance -> {
            if (instance instanceof RfInstance) {
                RfFileDef file = instance.getFile();
                if (file == null) {
                    return true;
                }
                instance.visitHidObject(null, new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator operator) {
                        if (!(PortConnectionUtils.isFullNamedConnected((IHidOperator)operator) || PortConnectionUtils.isFullNamedUnconnected((IHidOperator)operator) || PortConnectionUtils.isImplicitNamedConnected((IHidOperator)operator))) {
                            return true;
                        }
                        IHidObject left = operator.getLHValue();
                        if (!(left instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement element = ((RfHid)left).getElement();
                        if (!(element instanceof RfPort)) {
                            return true;
                        }
                        HidOperatorOccurrence occurence = operator.getOccurrence();
                        if (occurence.getVirtualOffset() != -1) {
                            return true;
                        }
                        RfDefElement declaration = instance.getDeclaration();
                        if (!(declaration instanceof RfInstanceDef)) {
                            return true;
                        }
                        RfInstanceDef instanceDef = (RfInstanceDef)declaration;
                        portsByInstance.putIfAbsent(instanceDef, new ArrayList());
                        ((List)portsByInstance.get(instanceDef)).add(operator);
                        ParserPath parserPath = instanceDef.getParserPath();
                        if (parserPath == null) {
                            return true;
                        }
                        instanceDefByParserPath.putIfAbsent(parserPath, new LinkedHashSet());
                        ((Set)instanceDefByParserPath.get(parserPath)).add(instanceDef);
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            return true;
        });
        this.checkNamedPortsIndentation(portsByInstance, instanceDefByParserPath);
    }

    private void checkNamedPortsIndentation(Map<RfInstanceDef, List<RfHidOperator>> portsByInstance, Map<ParserPath, Set<RfInstanceDef>> instanceDefByParserPath) {
        for (Map.Entry<ParserPath, Set<RfInstanceDef>> entry : instanceDefByParserPath.entrySet()) {
            ParserPath parserPath = entry.getKey();
            Set<RfInstanceDef> instanceDefsInFile = entry.getValue();
            this.notifyCheckAlive();
            Map<RfInstanceDef, Integer> linesWithPharanthesesStart = this.getMapOfPharantheseStart(instanceDefsInFile);
            for (Map.Entry<RfInstanceDef, Integer> second : linesWithPharanthesesStart.entrySet()) {
                RfInstanceDef instanceDef = second.getKey();
                int instanceOffset = instanceDef.getLabelStartOffset();
                Integer lineWithPharanthesesStart = second.getValue();
                Integer lineWithPharanthesesEnd = instanceDef.getEndLine();
                List<RfHidOperator> portsOfInstance = portsByInstance.get(instanceDef);
                Map<Integer, List<RfHidOperator>> operatorsByLine = this.getOperatorsByLine(portsOfInstance);
                this.addHits(parserPath, lineWithPharanthesesStart, lineWithPharanthesesEnd, instanceOffset, operatorsByLine);
            }
        }
    }

    private void addHits(ParserPath parserPath, Integer lineWithPharanthesesStart, Integer lineWithPharanthesesEnd, int instanceOffset, Map<Integer, List<RfHidOperator>> operatorsByLine) {
        LiteralToken token;
        int lastLineWithOperators = lineWithPharanthesesStart;
        if (this.pCheckSpaceAfterInstanceName && (token = this.getWSParser().getToken(instanceOffset, parserPath)) != null && token.getStringToken().contains("(")) {
            this.addHit(parserPath, (int)lineWithPharanthesesStart, "There should be space between the instance name and the opening paranthesis of the port list!", null, new VerissimoAutofixAdditionalInfo(AUTOFIX_UNAVAILABLE_MESSAGE2, null));
        }
        for (Map.Entry<Integer, List<RfHidOperator>> entry : operatorsByLine.entrySet()) {
            int line = entry.getKey();
            List<RfHidOperator> operatorsOnLine = entry.getValue();
            RfHidOperator operator = operatorsOnLine.get(0);
            HidOperatorOccurrence occurence = operator.getOccurrence();
            if (occurence == null) continue;
            if (line == lineWithPharanthesesStart) {
                this.addHit(parserPath, (HidOccurrence)occurence, "Named port connection " + HidUtils.toNiceString((IHidObject)operator) + " should not be on the same line as module instantiation!", new VerissimoAutofixAdditionalInfo(occurence.getOffset(), lineWithPharanthesesStart));
            } else {
                if (this.isNotProperlyIndented(parserPath, line, lineWithPharanthesesStart)) {
                    this.addHit(parserPath, (HidOccurrence)occurence, "Line containing named port connection " + HidUtils.toNiceString((IHidObject)operator) + " should use " + this.pNofSpaces + " more spaces for indentation compared to line " + lineWithPharanthesesStart + "!", new VerissimoAutofixAdditionalInfo(occurence.getOffset(), lineWithPharanthesesStart));
                }
                lastLineWithOperators = Math.max(lastLineWithOperators, line);
            }
            if (this.pAllowConnectionsOnTheSameLine) continue;
            int i = 1;
            while (i < operatorsOnLine.size()) {
                operator = operatorsOnLine.get(0);
                occurence = operator.getOccurrence();
                if (occurence != null) {
                    this.addHit(parserPath, (HidOccurrence)occurence, this.getMultilineMessage(operatorsOnLine, i), new VerissimoAutofixAdditionalInfo(operatorsOnLine.get(i).getOccurrence().getOffset(), lineWithPharanthesesStart));
                }
                ++i;
            }
        }
        if (this.pEndingParanthesisOnDifferentLine) {
            if (lineWithPharanthesesEnd != lastLineWithOperators + 1) {
                this.addHit(parserPath, (int)lineWithPharanthesesEnd, "Ending parathesis on line " + lineWithPharanthesesEnd + " should be on the following line compared to the last name port connection " + lastLineWithOperators + "!", null, new VerissimoAutofixAdditionalInfo(AUTOFIX_UNAVAILABLE_MESSAGE, null));
            } else if (this.endingDifferentIndentationAsFirst(parserPath, lineWithPharanthesesStart, lineWithPharanthesesEnd)) {
                this.addHit(parserPath, (int)lineWithPharanthesesEnd, "Ending paranthesis on line " + lineWithPharanthesesEnd + " should have the same indentation as the line with starting paranthesis " + lineWithPharanthesesStart + "!", null, new VerissimoAutofixAdditionalInfo(AUTOFIX_UNAVAILABLE_MESSAGE, null));
            }
        }
    }

    private String getMultilineMessage(List<RfHidOperator> operatorsOnLine, int index) {
        StringBuilder result = new StringBuilder("");
        result.append("Named port connection ");
        result.append(HidUtils.toNiceString((IHidObject)((IHidObject)operatorsOnLine.get(index))));
        result.append(" should not be on the same line as ");
        ArrayList<RfHidOperator> copy = new ArrayList<RfHidOperator>(operatorsOnLine);
        copy.remove(index);
        if (copy.size() != 1) {
            result.append("named port connections ");
        } else {
            result.append("named port connection ");
        }
        int i = 0;
        while (i < copy.size() - 1) {
            result.append(HidUtils.toNiceString((IHidObject)((IHidObject)copy.get(i))));
            result.append(", ");
            ++i;
        }
        if (copy.size() != 1) {
            result.deleteCharAt(result.length() - 2);
            result.append(" and ");
        }
        result.append(HidUtils.toNiceString((IHidObject)((IHidObject)copy.get(copy.size() - 1))));
        result.append("!");
        return result.toString();
    }

    private Map<Integer, List<RfHidOperator>> getOperatorsByLine(List<RfHidOperator> portsOfInstance) {
        HashMap<Integer, List<RfHidOperator>> result = new HashMap<Integer, List<RfHidOperator>>();
        for (RfHidOperator operator : portsOfInstance) {
            HidOperatorOccurrence occurence = operator.getOccurrence();
            if (occurence == null) continue;
            int line = occurence.getLine();
            result.putIfAbsent(line, new ArrayList());
            ((List)result.get(line)).add(operator);
        }
        return result;
    }

    private boolean isNotProperlyIndented(ParserPath parserPath, Integer line, Integer openPharantheseLine) {
        String openPharanthese = this.contentReader.getLine(parserPath, openPharantheseLine);
        String currentLine = this.contentReader.getLine(parserPath, line);
        return this.isNotProperlyIndentedHelper(openPharanthese, currentLine, this.pNofSpaces);
    }

    private boolean endingDifferentIndentationAsFirst(ParserPath parserPath, Integer openPharantheseLine, Integer closePharantheseLine) {
        String openPharanthese = this.contentReader.getLine(parserPath, openPharantheseLine);
        String closePharanthese = this.contentReader.getLine(parserPath, closePharantheseLine);
        return this.isNotProperlyIndentedHelper(openPharanthese, closePharanthese, 0);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isNotProperlyIndentedHelper(String pharantheseString, String namedPortConnectionString, int allowedDiff) {
        i = 0;
        commentInIfLine = false;
        commentInIssueLine = false;
        nrOfTabsIfLine = 0;
        nrOfTabsIssueLine = 0;
        nrOfSpacesIfLine = 0;
        nrOfSpacesIssueLine = 0;
        while (i < Math.min(pharantheseString.length(), namedPortConnectionString.length()) - 1) {
            if (this.isCommentBeginning(namedPortConnectionString, i)) {
                commentInIssueLine = true;
            }
            if (commentInIssueLine && this.isCommentEnd(namedPortConnectionString, i)) {
                commentInIssueLine = false;
            }
            if (this.isCommentBeginning(pharantheseString, i)) {
                commentInIfLine = true;
            }
            if (commentInIfLine && this.isCommentEnd(pharantheseString, i)) {
                commentInIfLine = false;
            }
            if (!commentInIfLine && !Character.isWhitespace(pharantheseString.charAt(i)) || !commentInIssueLine && !Character.isWhitespace(namedPortConnectionString.charAt(i))) break;
            currentCharIfLine = pharantheseString.charAt(i);
            currentCharIssueLine = namedPortConnectionString.charAt(i);
            if (currentCharIfLine == '\t') {
                ++nrOfTabsIfLine;
            } else {
                ++nrOfSpacesIfLine;
            }
            if (currentCharIssueLine == '\t') {
                ++nrOfTabsIssueLine;
            } else {
                ++nrOfSpacesIssueLine;
            }
            ++i;
        }
        if (i <= namedPortConnectionString.length()) ** GOTO lbl43
        return true;
lbl-1000:
        // 1 sources

        {
            if (this.isCommentBeginning(namedPortConnectionString, i)) {
                commentInIssueLine = true;
            }
            if (commentInIssueLine && this.isCommentEnd(namedPortConnectionString, i)) {
                commentInIssueLine = false;
            }
            if (!commentInIssueLine && !Character.isWhitespace(namedPortConnectionString.charAt(i))) break;
            currentCharLine = namedPortConnectionString.charAt(i);
            if (currentCharLine == '\t') {
                ++nrOfTabsIssueLine;
            } else {
                ++nrOfSpacesIssueLine;
            }
            ++i;
lbl43:
            // 2 sources

            ** while (i < namedPortConnectionString.length() - 1)
        }
lbl44:
        // 2 sources

        if (nrOfTabsIfLine != nrOfTabsIssueLine) {
            return true;
        }
        return nrOfSpacesIssueLine - nrOfSpacesIfLine != allowedDiff;
    }

    private boolean isCommentBeginning(String line, int index) {
        return line.charAt(index) == '/' && line.charAt(index + 1) == '*';
    }

    private boolean isCommentEnd(String line, int index) {
        if (index < 3) {
            return line.charAt(index) == '*' && line.charAt(index + 1) == '/';
        }
        return line.charAt(index - 3) != '/' && line.charAt(index - 2) == '*' && line.charAt(index - 1) == '/';
    }

    private Map<RfInstanceDef, Integer> getMapOfPharantheseStart(Set<RfInstanceDef> instanceDefsInFile) {
        HashMap<RfInstanceDef, Integer> result = new HashMap<RfInstanceDef, Integer>();
        COMMENT_STATUS commentStatus = null;
        block5: for (RfInstanceDef instanceDef : instanceDefsInFile) {
            int startLine = instanceDef.getLabelStartLine();
            int endLine = instanceDef.getEndLine();
            int lineForInstanceDef = startLine;
            commentStatus = COMMENT_STATUS.UNKNOWN;
            ParserPath parserPath = instanceDef.getParserPath();
            boolean foundPharantheses = false;
            boolean isTypeParameterArea = false;
            int pharantheseCounter = 0;
            while (lineForInstanceDef <= endLine) {
                String line = this.contentReader.getLine(parserPath, lineForInstanceDef);
                int i = 0;
                while (i < line.length()) {
                    int prev = i != 0 ? (int)line.charAt(i - 1) : 10;
                    char current = line.charAt(i);
                    switch (commentStatus) {
                        case MULTILINE_COMMENT: {
                            if (prev != 42 || current != '/') break;
                            commentStatus = COMMENT_STATUS.NOT_IN_COMMENT;
                            break;
                        }
                        case NOT_IN_COMMENT: {
                            if (prev == 47 && current == '/') {
                                commentStatus = COMMENT_STATUS.SINGLE_LINE_COMMENT;
                            }
                            if (prev != 47 || current != '*') break;
                            commentStatus = COMMENT_STATUS.MULTILINE_COMMENT;
                            break;
                        }
                        case UNKNOWN: {
                            if (prev == 47 && current == '/') {
                                commentStatus = COMMENT_STATUS.SINGLE_LINE_COMMENT;
                            }
                            if (prev == 47 && current == '*') {
                                commentStatus = COMMENT_STATUS.MULTILINE_COMMENT;
                            }
                            if (prev != 42 || current != '/') break;
                            commentStatus = COMMENT_STATUS.NOT_IN_COMMENT;
                            result.remove(instanceDef);
                            isTypeParameterArea = false;
                            break;
                        }
                    }
                    if (current == '#' && (commentStatus == COMMENT_STATUS.NOT_IN_COMMENT || commentStatus == COMMENT_STATUS.UNKNOWN)) {
                        isTypeParameterArea = true;
                    }
                    if (current == '(' && (commentStatus == COMMENT_STATUS.NOT_IN_COMMENT || commentStatus == COMMENT_STATUS.UNKNOWN)) {
                        if (!isTypeParameterArea) {
                            result.putIfAbsent(instanceDef, lineForInstanceDef);
                            if (commentStatus == COMMENT_STATUS.NOT_IN_COMMENT) {
                                foundPharantheses = true;
                                break;
                            }
                        } else {
                            ++pharantheseCounter;
                        }
                    }
                    if (current == ')' && isTypeParameterArea && (commentStatus == COMMENT_STATUS.NOT_IN_COMMENT || commentStatus == COMMENT_STATUS.UNKNOWN) && --pharantheseCounter == 0) {
                        isTypeParameterArea = false;
                    }
                    if (i == line.length() - 1 && commentStatus == COMMENT_STATUS.SINGLE_LINE_COMMENT) {
                        commentStatus = COMMENT_STATUS.NOT_IN_COMMENT;
                    }
                    ++i;
                }
                if (foundPharantheses) continue block5;
                ++lineForInstanceDef;
            }
        }
        return result;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.contentReader != null) {
            this.contentReader.clear();
        }
    }

    private static enum COMMENT_STATUS {
        UNKNOWN,
        SINGLE_LINE_COMMENT,
        MULTILINE_COMMENT,
        NOT_IN_COMMENT;

    }

    class ContentReader {
        private Map<ParserPath, List<String>> readFiles = new HashMap<ParserPath, List<String>>();

        String getLine(ParserPath parserPath, Integer line) {
            List<String> fileContent;
            if (!this.readFiles.containsKey(parserPath)) {
                this.readFile(parserPath);
            }
            if ((fileContent = this.readFiles.get(parserPath)).size() <= line - 1) {
                return null;
            }
            return fileContent.get(line - 1);
        }

        private void readFile(ParserPath parserPath) {
            block13: {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(parserPath.path));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            this.readFiles.putIfAbsent(parserPath, new ArrayList());
                            this.readFiles.get(parserPath).add(line);
                        }
                    }
                    catch (IOException e) {
                        Check_SVTB_1_1_16.this.fOVMProject.notifyCheckException(Check_SVTB_1_1_16.this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        if (reader == null) break block13;
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            Check_SVTB_1_1_16.this.fOVMProject.notifyCheckException(Check_SVTB_1_1_16.this, e2);
                            DVTLogger.INSTANCE.logError((Throwable)e2);
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Check_SVTB_1_1_16.this.fOVMProject.notifyCheckException(Check_SVTB_1_1_16.this, e);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
        }

        private void clear() {
            this.readFiles.clear();
        }
    }
}

