/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_17;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPortDef;

@CheckVersion(value="20.1.8")
@CheckID(value="SVTB.1.1.17")
@CheckName(value="SVTB.1.1.17")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Member declaration spacing.")
@CheckDescription(value="This rule checks there is only one whitespace between type and member name in member declaration.\n\nExamples:\nint a; // allowed\nint    b; // not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_17.class)
public class Check_SVTB_1_1_17
extends AbstractFormattingDisabledCheck {
    public Check_SVTB_1_1_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        try {
            this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    if (!(namedElement instanceof RfField)) {
                        return true;
                    }
                    if (namedElement.isPredefined()) {
                        return true;
                    }
                    if (namedElement.isAnonymous()) {
                        return true;
                    }
                    if (namedElement.getDeclaration() == null) {
                        return true;
                    }
                    RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                    if (enclosingScope == null) {
                        return true;
                    }
                    if (namedElement.getDeclaration().getReparseInfo() != null) {
                        return true;
                    }
                    Check_SVTB_1_1_17.this.notifyCheckAlive();
                    if (namedElement.getFile() == null) {
                        return true;
                    }
                    ParserPath parserPath = namedElement.getFile().getParserPath();
                    if (Check_SVTB_1_1_17.this.checkPreWaivers(parserPath)) {
                        return true;
                    }
                    Collection declarations = namedElement.getDeclarations();
                    for (RfDefElement declaration : declarations) {
                        LiteralToken token;
                        int offset = declaration.getStartOffset();
                        String namedElementString = namedElement.getName();
                        if (enclosingScope instanceof RfModule && ((RfModule)enclosingScope).isNonAnsi() && declaration instanceof RfPortDef && ((RfPortDef)declaration).isInListOfPorts() || (token = Check_SVTB_1_1_17.this.getWSParser().getToken(offset, parserPath)) == null || !Check_SVTB_1_1_17.this.isHit(token)) continue;
                        Check_SVTB_1_1_17.this.addHit(parserPath, declaration.getStartLine(), "Member '" + namedElementString + "' doesn't have exactly one whitespace between type and member!", null, new VerissimoAutofixAdditionalInfo(token));
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean isHit(LiteralToken token) {
        if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        if (token.isFirstTokenOnLine()) {
            return false;
        }
        return token.getNoSpacesBefore() != 1 || token.getNoTabsBefore() != 0;
    }
}

