/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="20.1.8")
@CheckID(value="SVTB.1.1.18")
@CheckName(value="SVTB.1.1.18")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Keywords spacing.")
@CheckDescription(value="This rule checks there is only one whitespace before and after a keyword.\n\nException 1: Before a keyword at the beginning of a line.\nException 2: After a keyword at the end of a line.\nException 3: Before keywords that immediately follow a group opening, such as an open parenthesis.\n\nExamples:\ninput signed [31:0] phase; // allowed\ninput   signed  [31:0] phase; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_1_18
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final char CHAR_DOLLAR_SIGN = '$';
    private static final char CHAR_UNDERSCORE = '_';
    public static final String[] KEYWORDS = new String[]{"accept_on", "alias", "always", "always_comb", "always_ff", "always_latch", "and", "assert", "assign", "assume", "automatic", "before", "begin", "bind", "bins", "binsof", "bit", "break", "buf", "bufif0", "bufif1", "byte", "case", "casex", "casez", "cell", "chandle", "checker", "class", "clocking", "cmos", "config", "const", "constraint", "context", "continue", "cover", "covergroup", "coverpoint", "cross", "deassign", "default", "defparam", "design", "disable", "dist", "do", "edge", "else", "end", "endcase", "endchecker", "endclass", "endclocking", "endconfig", "endfunction", "endgenerate", "endgroup", "endinterface", "endmodule", "endpackage", "endprimitive", "endprogram", "endproperty", "endspecify", "endsequence", "endtable", "endtask", "enum", "event", "eventually", "expect", "export", "extends", "extern", "final", "first_match", "for", "force", "foreach", "forever", "fork", "forkjoin", "function", "generate", "genvar", "global", "highz0", "highz1", "if", "iff", "ifnone", "ignore_bins", "illegal_bins", "implements", "implies", "import", "incdir", "include", "initial", "inout", "input", "inside", "instance", "int", "integer", "interconnect", "interface", "intersect", "join", "join_any", "join_none", "large", "let", "liblist", "library", "local", "localparam", "logic", "longint", "macromodule", "matches", "medium", "modport", "module", "nand", "negedge", "nettype", "new", "nexttime", "nmos", "nor", "noshowcancelled", "not", "notif0", "notif1", "null", "or", "output", "package", "packed", "parameter", "pmos", "posedge", "primitive", "priority", "program", "property", "protected", "pull0", "pull1", "pulldown", "pullup", "pulsestyle_ondetect", "pulsestyle_onevent", "pure", "rand", "randc", "randcase", "randsequence", "rcmos", "real", "realtime", "ref", "reg", "reject_on", "release", "repeat", "restrict", "return", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "s_always", "s_eventually", "s_nexttime", "s_until", "s_until_with", "scalared", "sequence", "shortint", "shortreal", "showcancelled", "signed", "small", "soft", "solve", "specify", "specparam", "static", "string", "strong", "strong0", "strong1", "struct", "super", "supply0", "supply1", "sync_accept_on", "sync_reject_on", "table", "tagged", "task", "this", "throughout", "time", "timeprecision", "timeunit", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "type", "typedef", "union", "unique", "unique0", "unsigned", "until", "until_with", "untyped", "use", "uwire", "var", "vectored", "virtual", "void", "wait", "wait_order", "wand", "weak", "weak0", "weak1", "while", "wildcard", "wire", "with", "within", "wor", "xnor", "xor"};
    public static final String ALLOWED_CHARS_BEFORE_KEYWORD = "{[(`";
    @CheckParameter(defaultValue="inout, input, output, signed, unsigned, integer, real, int, reg, byte, wire, bit, logic, string, null, void, return, new, this, super", description="Specifies which keywords should be skipped. Comma separated list of keywords.", name="skippedKeywords", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkippedKeywords;
    @CheckParameter(defaultValue="", description="Specifies which keywords should be checked. Comma separated list of keywords.", name="checkedKeywords", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedKeywords;

    public Check_SVTB_1_1_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (!this.pSkippedKeywords.isEmpty() && !this.pCheckedKeywords.isEmpty()) {
            this.signalParamError("The 'checkedKeywords' parameter can only be used when the 'skippedKeywords' parameter is empty!", true);
        }
        HashSet<String> keywordsSet = new HashSet<String>(Arrays.asList(KEYWORDS));
        for (String pKeyword : this.pCheckedKeywords) {
            if (keywordsSet.contains(pKeyword)) continue;
            this.signalParamError("'" + pKeyword + "' is not a valid keyword!", true);
        }
        for (String pKeyword : this.pSkippedKeywords) {
            if (keywordsSet.contains(pKeyword)) continue;
            this.signalParamError("'" + pKeyword + "' is not a valid keyword!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        Set<String> keywordsSet = new HashSet<String>(Arrays.asList(KEYWORDS));
        if (!this.pCheckedKeywords.isEmpty()) {
            keywordsSet = this.pCheckedKeywords;
        }
        if (!this.pSkippedKeywords.isEmpty()) {
            for (String pKeyword : this.pSkippedKeywords) {
                if (!keywordsSet.contains(pKeyword)) continue;
                keywordsSet.remove(pKeyword);
            }
        }
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            block2: for (LiteralToken token : tokens.values()) {
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                String stringToken = token.getStringToken();
                if (keywordsSet.contains(stringToken)) {
                    if (!this.isHitWhenTokenIsKeyword(token)) continue;
                    this.addHit(path, token.getLineNumber(), "Keyword '" + stringToken + "' doesn't have exactly one space before and after!", null);
                    continue;
                }
                for (String keyword : keywordsSet) {
                    int startIndex = stringToken.indexOf(keyword);
                    if (startIndex == -1 || !this.isKeywordInsideToken(startIndex, token, keyword)) continue;
                    this.addHit(path, token.getLineNumber(), "Keyword '" + keyword + "' doesn't have exactly one space before and after!", null);
                    continue block2;
                }
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean validIdentifierChar(char c) {
        if (Character.isAlphabetic(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (c == '_') {
            return true;
        }
        return c == '$';
    }

    private boolean isKeywordInsideToken(int startIndex, LiteralToken token, String keyword) {
        String stringToken = token.getStringToken();
        int endIndex = startIndex + keyword.length();
        if (stringToken.startsWith(keyword)) {
            char charAfterKeyword = stringToken.charAt(endIndex);
            return !this.validIdentifierChar(charAfterKeyword);
        }
        if (stringToken.endsWith(keyword)) {
            char charBeforeKeyword = stringToken.charAt(startIndex - 1);
            if (this.validIdentifierChar(charBeforeKeyword)) {
                return false;
            }
            return ALLOWED_CHARS_BEFORE_KEYWORD.indexOf(charBeforeKeyword) == -1 || token.getNoSpacesAfter() != 1 && !token.isLastTokenOnLine();
        }
        char charBeforeKeyword = stringToken.charAt(startIndex - 1);
        char charAfterKeyword = stringToken.charAt(endIndex);
        return !this.validIdentifierChar(charBeforeKeyword) && !this.validIdentifierChar(charAfterKeyword);
    }

    private boolean isHitWhenTokenIsKeyword(LiteralToken token) {
        if (token.isOnlyTokenOnLine()) {
            return false;
        }
        if (token.isFirstTokenOnLine() && token.getNoSpacesAfter() == 1) {
            return false;
        }
        if (token.isLastTokenOnLine() && token.getNoSpacesBefore() == 1) {
            return false;
        }
        return token.getNoSpacesBefore() != 1 || token.getNoSpacesAfter() != 1;
    }
}

