/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_19;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="20.1.8")
@CheckID(value="SVTB.1.1.19")
@CheckName(value="SVTB.1.1.19")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.PARENTHESIS})
@CheckTitle(value="No spacing between closing/opening parentheses")
@CheckDescription(value="This rule checks there are no spaces after opening parenthesis or before closing parenthesis.\n\nExamples:\nif ((x == 0)) // allowed\nif ( (x == 0) ) // not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_19.class)
public class Check_SVTB_1_1_19
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, the spaces before the closing parenthesis are ignored if the parenthesis is placed on a new line.", name="skipNewLineClosingParenthesis", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipNewLineClosingParenthesis;
    private static final char CLOSE_PARENTHESIS_CHAR = ')';
    private static final char OPEN_PARENTHESIS_CHAR = '(';

    public Check_SVTB_1_1_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            for (LiteralToken token : tokens.values()) {
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                char firstChar = token.getStringToken().charAt(0);
                char lastChar = token.getStringToken().charAt(token.getLength() - 1);
                if (lastChar == '(' && token.getNoSpacesAfter() > 0) {
                    this.addHit(path, token.getLineNumber(), "Spaces found between opening parenthesis '" + token.getStringToken() + "' at the character position " + (token.getOffsetLine() + token.getLength()) + " on the line!", null, new VerissimoAutofixAdditionalInfo(token));
                }
                if (firstChar != ')' || token.getNoSpacesBefore() <= 0 || this.pSkipNewLineClosingParenthesis && token.isFirstTokenOnLine()) continue;
                this.addHit(path, token.getLineNumber(), "Spaces found between closing parenthesis '" + token.getStringToken() + "' at the character position " + (token.getOffsetLine() + 1) + " on the line!", null, new VerissimoAutofixAdditionalInfo(token));
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

