/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_20;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="20.1.11")
@CheckID(value="SVTB.1.1.20")
@CheckName(value="SVTB.1.1.20")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.TYPEDEF})
@CheckTitle(value="Spacing for typedefs and declarations")
@CheckDescription(value="This rule checks there are spaces between <elementKind>/union/enum/struct name and '#' or '{' in typedef or declaration.\n\nExamples:\ntypedef struct packed { // allowed\n  bit unused;\n} packed_struct;\n\ntypedef union tagged{ // not allowed\n  bit unused;\n} tagged_union;\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_1_1_20.class)
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
public class Check_SVTB_1_1_20
extends AbstractFormattingDisabledCheck {
    private static final String INTERFACE = "interface";
    private static final String MODULE = "module";
    private static final String CLASS = "class";
    private static final String PROGRAM = "program";
    private static final String INSTANCE = "instance";
    private static final Set<String> ELEMENT_KIND_SET = new HashSet<String>(Arrays.asList("interface", "module", "class", "program", "instance"));
    @CheckParameter(defaultValue="class, module, interface, program", description="Comma separated list of element kinds for which the declaration must have spaces between the element name and '#'. Possible values: class, module, interface, program, instance.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKind;
    @CheckParameter(defaultValue="false", description="When true, does not allow <elementKind>/union/enum/struct name and '#' to be on different lines.", name="checkNumberSignCharacterOnNewLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckNumberSignCharacterOnNewLine;

    public Check_SVTB_1_1_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String elementKind : this.pElementKind) {
            if (ELEMENT_KIND_SET.contains(elementKind)) continue;
            this.signalParamError("'" + elementKind + "' is not a valid value for parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.addHitsForTypedef();
        this.addHitsForDeclaration();
    }

    private void addHitsForDeclaration() {
        if (this.pElementKind.contains(CLASS)) {
            this.addHitsForDeclaration(this.fOVMProject.getAllClasses());
        }
        if (this.pElementKind.contains(MODULE)) {
            this.addHitsForDeclaration(this.fOVMProject.getAllModules());
        }
        if (this.pElementKind.contains(INTERFACE)) {
            this.addHitsForDeclaration(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKind.contains(PROGRAM)) {
            this.addHitsForDeclaration(this.fOVMProject.getAllPrograms());
        }
        if (this.pElementKind.contains(INSTANCE)) {
            this.addHitsForDeclaration(this.fOVMProject.getAllInstances());
        }
    }

    private void addHitsForDeclaration(NullProtectedList<? extends RfNamedElement> list) {
        block0: for (RfNamedElement rfNamedElement : list) {
            LiteralToken token;
            ParserPath path = rfNamedElement.getFile().getParserPath();
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            RfDefElement declaration = rfNamedElement.getDeclaration();
            if (declaration == null || declaration.getReparseInfo() != null || (token = this.getWSParser().getToken(declaration.getStartOffset(), path)) == null) continue;
            LiteralToken prevToken = null;
            int line = token.getLineNumber();
            if (this.pCheckNumberSignCharacterOnNewLine) {
                while (token != null) {
                    if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                        token = this.getWSParser().getNextToken(token, path);
                        continue;
                    }
                    if (token.getStringToken().indexOf("#") != -1) {
                        if (!this.isHit(token, false, true, line)) continue block0;
                        if (token.getStringToken().charAt(0) == '#' && prevToken != null) {
                            this.addHit(path, token.getLineNumber(), this.getStringHit(token, prevToken, false, true), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                            continue block0;
                        }
                        this.addHit(path, token.getLineNumber(), this.getStringHit(token, null, false, true), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                        continue block0;
                    }
                    if (token.getStringToken().indexOf(";") != -1) continue block0;
                    prevToken = token;
                    token = this.getWSParser().getNextToken(token, path);
                }
                continue;
            }
            if (!this.isHit(token, false, true, line)) continue;
            this.addHit(path, token.getLineNumber(), this.getStringHit(token, null, false, true), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
        }
    }

    private void addHitsForTypedef() {
        block0: for (RfNamedElement elem : this.fOVMProject.getAllTypedefs()) {
            ParserPath path = elem.getFile().getParserPath();
            if (this.checkPreWaivers(path) || !(elem instanceof RfTypeAlias) || elem.getDeclaration() != null && elem.getDeclaration().getReparseInfo() != null) continue;
            this.notifyCheckAlive();
            RfTypeAlias type = (RfTypeAlias)elem;
            IRfNamedElement translatedType = type.getTranslatedType(RfTypesResolver.create((IRfScopeElement)type.getEnclosingScope(), this.fOVMProject.getRfProject(), 30));
            int offsetToken = -1;
            if (type != null && type.getDataType() != null) {
                offsetToken = translatedType instanceof RfAssociatedType.RfUnresolvedTypeInfo ? type.getDataType().getOffsetOf((RfAssociatedType.RfUnresolvedTypeInfo)type.getUnresolvedType()) : type.getDataType().getOffset();
            }
            LiteralToken token = this.getWSParser().getToken(offsetToken, path);
            LiteralToken prevToken = null;
            if (token == null) continue;
            int line = token.getLineNumber();
            while (token != null) {
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                    token = this.getWSParser().getNextToken(token, path);
                    continue;
                }
                if (token.getStringToken().indexOf("#") != -1 && this.isHit(token, true, true, line)) {
                    if (token.getStringToken().charAt(0) == '#' && prevToken != null) {
                        this.addHit(path, token.getLineNumber(), this.getStringHit(token, prevToken, true, true), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                        continue block0;
                    }
                    this.addHit(path, token.getLineNumber(), this.getStringHit(token, null, true, true), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                    continue block0;
                }
                if (token.getStringToken().indexOf("{") != -1) {
                    if (!this.isHit(token, true, false, line)) continue block0;
                    this.addHit(path, token.getLineNumber(), this.getStringHit(token, null, true, false), null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                    continue block0;
                }
                if (token.getStringToken().indexOf(";") != -1) continue block0;
                prevToken = token;
                token = this.getWSParser().getNextToken(token, path);
            }
        }
    }

    private String getStringHit(LiteralToken token, LiteralToken prevToken, boolean isTypedef, boolean isNumberSign) {
        if (prevToken != null) {
            return String.valueOf(prevToken.toString()) + " and '#' should be on the same line";
        }
        char sign = isNumberSign ? (char)'#' : '{';
        String tokenString = token.toString();
        tokenString = tokenString.substring(0, tokenString.lastIndexOf(sign));
        String errorString = "There are no spaces between '" + tokenString + "'";
        return String.valueOf(isTypedef ? String.valueOf(errorString) + " and '" + sign + "' in typedef" : String.valueOf(errorString) + " and '#' in declaration") + " at line offset " + token.getOffsetLine() + "!";
    }

    private boolean isHit(LiteralToken token, boolean isTypedef, boolean isNumberSign, int line) {
        if (token == null) {
            return false;
        }
        String stringToken = token.getStringToken();
        if (isNumberSign && this.pCheckNumberSignCharacterOnNewLine && stringToken.charAt(0) == '#' && token.getLineNumber() != line) {
            return true;
        }
        if (stringToken.isEmpty() || stringToken.charAt(0) == '{' || stringToken.charAt(0) == '#') {
            return false;
        }
        if (isTypedef) {
            return true;
        }
        return stringToken.indexOf("#") != -1;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

