/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="20.1.11")
@CheckID(value="SVTB.1.1.21")
@CheckName(value="SVTB.1.1.21")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.COMMENT})
@CheckTitle(value="Single line comment spacing")
@CheckDescription(value="This rule checks there is only one whitespace after a single line comment identifier '//'.\n\nExamples:\n// allowed\n//not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_1_21
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="false", description="When true, more than one space is allowed after a comment identifier.", name="allowMultipleSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowMultipleSpaces;

    public Check_SVTB_1_1_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            for (LiteralToken token : tokens.values()) {
                LiteralToken prevToken;
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || !token.getStringToken().equals("//") || (prevToken = this.getWSParser().getPrevToken(token, path)) != null && prevToken.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT && !token.isFirstTokenOnLine() || this.pAllowMultipleSpaces && token.getNoSpacesAfter() != 0 || token.getNoSpacesAfter() == 1) continue;
                this.addHit(path, token.getLineNumber(), "Wrong spacing after //,  at the character position " + (token.getOffsetLine() + 1) + " on the line!", null);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

