/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="20.1.11")
@CheckID(value="SVTB.1.1.22")
@CheckName(value="SVTB.1.1.22")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Include guard formatting")
@CheckDescription(value="This rule checks there is an empty line before `ifndef and an empty line after `define. This rule is applied only on `ifndef and `define of include guards.\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_1_22
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String IFNDEF_STRING = "`ifndef";
    private static final String DEFINE_STRING = "`define";

    public Check_SVTB_1_1_22(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            LiteralToken defineToken;
            LiteralToken ifndefToken;
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            LinkedList<LiteralToken> literalTokens = new LinkedList<LiteralToken>(tokens.values());
            int i = 0;
            while (i < literalTokens.size()) {
                LiteralToken token = (LiteralToken)literalTokens.get(i);
                if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) break;
                ++i;
            }
            if (i == literalTokens.size() || !(ifndefToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(IFNDEF_STRING) || !(defineToken = (LiteralToken)literalTokens.get(i + 2)).getStringToken().equals(DEFINE_STRING) || !((LiteralToken)literalTokens.get(i + 1)).getStringToken().equals(((LiteralToken)literalTokens.get(i + 3)).getStringToken())) continue;
            if (i == 0) {
                if (ifndefToken.getLineNumber() == 1) {
                    this.addHit(path, ifndefToken.getLineNumber(), "No empty line before `ifndef " + literalTokens.get(i + 1) + "!", null);
                }
            } else if (((LiteralToken)literalTokens.get(i - 1)).getLineNumber() >= ifndefToken.getLineNumber() - 1) {
                this.addHit(path, ifndefToken.getLineNumber(), "No empty line before `ifndef " + literalTokens.get(i + 1) + "!", null);
            }
            if (i + 4 == literalTokens.size() || ((LiteralToken)literalTokens.get(i + 4)).getLineNumber() > defineToken.getLineNumber() + 1) continue;
            this.addHit(path, defineToken.getLineNumber(), "No empty line after `define " + literalTokens.get(i + 3) + "!", null);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

