/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_23;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="20.1.33")
@CheckID(value="SVTB.1.1.23")
@CheckName(value="SVTB.1.1.23")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.INTERFACE, RuleLabel.PARAMETER})
@CheckTitle(value="Signal list formatting for interfaces with parameters")
@CheckDescription(value="This rule checks the following for interfaces with parameters:\n1) The signal list starts on an empty line.\n2) There is only one unclosed opening parenthesis per line.\n3) There is only one closing parenthesis per line (when the opening parenthesis isn't on the same line).\n\nExamples:\ninterface sample_if_fail #(\n  int unsigned P1 = 1,\n  int unsigned P2 = 2) (input bit clk, input bit rst); // not allowed\nendinterface\n\ninterface sample_if_correct #(\n  int unsigned P1 = 1,\n  int unsigned P2 = 2\n)( // allowed\n  input bit clk, input bit asd,\n  input bit rst\n);\nendinterface\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_23.class)
public class Check_SVTB_1_1_23
extends AbstractFormattingDisabledCheck {
    private static final int ITERATION_LIMIT = 5;

    public Check_SVTB_1_1_23(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void performCheckImpl() {
        block0: for (RfNamedElement namedElem : this.fOVMProject.getAllInterfaces()) {
            LiteralToken lastPort;
            ParserPath file = namedElem.getFile().getParserPath();
            if (this.checkPreWaivers(file) || !(namedElem instanceof RfInterface)) continue;
            RfInterface interfaceElem = (RfInterface)namedElem;
            this.notifyCheckAlive();
            List<? extends IRfNamedElement> paramInPortList = this.getParamInPortList(interfaceElem);
            if (paramInPortList == null || paramInPortList.isEmpty()) continue;
            IRfNamedElement lastParameterElement = paramInPortList.get(paramInPortList.size() - 1);
            LiteralToken lastParameter = this.getWSParser().getTokenContainingOffset(lastParameterElement.getOffset(), file);
            LiteralToken firstPort = this.getPortToken(interfaceElem, file, true);
            if (lastParameter == null || firstPort == null) continue;
            if (lastParameter.getLineNumber() == firstPort.getLineNumber()) {
                this.addHit(file, firstPort.getLineNumber(), "Interface: '" + interfaceElem.getName() + "' has ports on the same line with parameters!", null, new VerissimoAutofixAdditionalInfo(interfaceElem));
                continue;
            }
            LiteralToken token = lastPort = this.getPortToken(interfaceElem, file, false);
            int i = 0;
            while (i < 5) {
                if (token == null) break;
                if (token.getStringToken().contains(")")) {
                    if (lastPort.getLineNumber() != token.getLineNumber()) break;
                    this.addHit(file, token.getLineNumber(), "Interface: '" + interfaceElem.getName() + "' has a closing parenthesis on the same line with the ports!", null, new VerissimoAutofixAdditionalInfo(interfaceElem));
                    break;
                }
                token = this.getWSParser().getNextToken(token, file);
                ++i;
            }
            token = lastParameter;
            i = 0;
            while (i < 5) {
                block8: {
                    if (token == null) continue block0;
                    if (token.getStringToken().contains("(")) {
                        if (i == 0 && token.getStringToken().indexOf("(") < token.getStringToken().indexOf(lastParameterElement.getName())) {
                            token = this.getWSParser().getNextToken(token, file);
                            break block8;
                        } else {
                            if (firstPort.getLineNumber() != token.getLineNumber()) continue block0;
                            this.addHit(file, token.getLineNumber(), "Interface: '" + interfaceElem.getName() + "' has an opening parenthesis on the same line with the ports!", null, new VerissimoAutofixAdditionalInfo(interfaceElem));
                            continue block0;
                        }
                    }
                    token = this.getWSParser().getNextToken(token, file);
                }
                ++i;
            }
        }
    }

    private List<? extends IRfNamedElement> getParamInPortList(RfInterface interfaceElem) {
        List<RfField> localParameters = new ArrayList<RfField>(interfaceElem.getLocalParameters());
        localParameters = localParameters.stream().filter(x -> x instanceof RfField && ((RfField)x).isInParameterPortList()).collect(Collectors.toList());
        return localParameters;
    }

    private LiteralToken getPortToken(RfInterface interfaceElem, ParserPath file, boolean firstPort) {
        ArrayList<IRfPortElement> localPorts = new ArrayList<IRfPortElement>(interfaceElem.getLocalPorts());
        if (localPorts == null || localPorts.isEmpty()) {
            return null;
        }
        RfPort port = firstPort ? (RfPort)localPorts.get(0) : (RfPort)localPorts.get(localPorts.size() - 1);
        return this.getWSParser().getTokenContainingOffset(port.getOffset(), file);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

