/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_24;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfPortDef;

@CheckVersion(value="20.1.30")
@CheckID(value="SVTB.1.1.24")
@CheckName(value="SVTB.1.1.24")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Vertical alignment for variables")
@CheckDescription(value="This rule checks that variables(fields, parameters, arguments, ports, etc.) are vertically aligned inside a declaration block.\n\nExamples:\nclass base1;\n  int    a;\n  int    b; // allowed\nendclass\n\nclass base2;\n  int    a;\n  int  b; // not allowed\nendclass\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_24.class)
public class Check_SVTB_1_1_24
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, method arguments will be ignored.", name="skipMethodArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipMethodArguments;
    @CheckParameter(defaultValue="false", description="When true, class parameters will be ignored.", name="skipClassParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipClassParameters;
    private HashMap<ParserPath, List<RfDefElement>> projectVariablesMap;
    private DocumentManager docManager;
    private static final Comparator<RfDefElement> DEF_ELEMENT_COMPARATOR = (def1, def2) -> {
        if (def1.getStartLine() == def2.getStartLine()) {
            return def1.getStartOffset() - def2.getStartOffset();
        }
        return def1.getStartLine() - def2.getStartLine();
    };
    private int prevLineNumber = -1;
    private int rightmostOffset = -1;
    private ParserPath prevPath;
    private RfDefElement prevDefElement;
    private List<RfDefElement> elementsInCrtBlock = new LinkedList<RfDefElement>();
    private List<RfDefElement> elementsOnSameLine = new ArrayList<RfDefElement>();
    private static final String AUTOFIX_ERROR_MESSAGE = "This line is part of a declaration block that has lines containing tabs: see line {0}.\nReplace those tabs with spaces";

    public Check_SVTB_1_1_24(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.docManager = this.getDocumentManager();
        this.projectVariablesMap = new HashMap();
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)namedElement;
            if (field.isImplicitSignal()) {
                return true;
            }
            if (this.pSkipMethodArguments && field.isArgument()) {
                return true;
            }
            if (this.pSkipClassParameters && field.isInParameterPortList() && field.getEnclosingScope() instanceof RfClass) {
                return true;
            }
            if (field.isPredefined() || field.isAnonymous() || field.isGenvar()) {
                return true;
            }
            if (field instanceof RfInstance) {
                return true;
            }
            this.notifyCheckAlive();
            if (field.getFile() == null) {
                return true;
            }
            Collection declarations = field.getDeclarations();
            for (RfDefElement declaration : declarations) {
                ParserPath path;
                if (declaration == null || declaration.getEnclosingScope() == null || declaration.getReparseInfo() != null || this.checkPreWaivers(path = declaration.getParserPath())) continue;
                List<RfDefElement> defElementsSet = this.projectVariablesMap.get(path);
                if (defElementsSet == null) {
                    this.projectVariablesMap.put(path, new ArrayList());
                }
                this.projectVariablesMap.get(path).add(declaration);
            }
            return true;
        });
        this.parseVariables();
        this.docManager.deactivate();
    }

    public void parseVariables() {
        for (Map.Entry<ParserPath, List<RfDefElement>> entry : this.projectVariablesMap.entrySet()) {
            ParserPath path = entry.getKey();
            List defElements = entry.getValue().stream().sorted(DEF_ELEMENT_COMPARATOR).collect(Collectors.toList());
            for (RfDefElement defElement : defElements) {
                if (defElement == null) continue;
                this.addHitIfExists(path, defElement);
            }
        }
        this.giveHits();
    }

    private boolean isBlockChanged(int lineNumber, ParserPath path, RfDefElement defElement) {
        if (this.prevLineNumber == -1 || this.prevDefElement == null || this.prevPath == null) {
            return true;
        }
        if (lineNumber > this.prevLineNumber + 1 || lineNumber < this.prevLineNumber) {
            return true;
        }
        if (!path.equals((Object)this.prevPath)) {
            return true;
        }
        RfField prevField = (RfField)this.prevDefElement.getNamedElement();
        RfField field = (RfField)defElement.getNamedElement();
        if (prevField.isInParameterPortList() != field.isInParameterPortList()) {
            return true;
        }
        if (!prevField.getEnclosingScope().equals(field.getEnclosingScope())) {
            return true;
        }
        if (this.prevDefElement instanceof RfPortDef) {
            if (defElement instanceof RfPortDef && ((RfPortDef)this.prevDefElement).isInListOfPorts() != ((RfPortDef)defElement).isInListOfPorts()) {
                return true;
            }
            if (!(defElement instanceof RfPortDef) && ((RfPortDef)this.prevDefElement).isInListOfPorts()) {
                return true;
            }
        }
        if (prevField.getEnclosingScope() instanceof RfFunction) {
            RfDefElement declaration = ((RfFunction)prevField.getEnclosingScope()).getDeclaration();
            boolean ansiStyle = ((RfFunctionDef)declaration).isANSIStyle();
            if (!ansiStyle) {
                return false;
            }
            if (this.prevDefElement instanceof RfFieldDef && defElement instanceof RfFieldDef && ((RfFieldDef)this.prevDefElement).hasDirection() != ((RfFieldDef)defElement).hasDirection()) {
                return true;
            }
        }
        return false;
    }

    private void updateBlock(ParserPath path, RfDefElement defElement, int crtOffset) {
        this.prevLineNumber = defElement.getStartLine();
        this.prevPath = path;
        this.prevDefElement = defElement;
        this.rightmostOffset = crtOffset;
        this.elementsOnSameLine.clear();
    }

    private void addHitIfExists(ParserPath path, RfDefElement defElement) {
        int lineNumber = defElement.getStartLine();
        if (this.isBlockChanged(lineNumber, path, defElement)) {
            this.giveHits();
            this.updateBlock(path, defElement, this.getOffsetOnLine(defElement, path));
            this.elementsInCrtBlock.add(defElement);
            return;
        }
        if (lineNumber == this.prevLineNumber) {
            this.elementsOnSameLine.add(this.prevDefElement);
            LiteralToken prevDefElementToken = this.getWSParser().getTokenContainingOffset(this.prevDefElement.getStartOffset(), path);
            LiteralToken defElementToken = this.getWSParser().getTokenContainingOffset(defElement.getStartOffset(), path);
            if (prevDefElementToken != null && defElementToken != null && !prevDefElementToken.equals(defElementToken)) {
                boolean remove = false;
                if (prevDefElementToken.getStringToken().contains(";") && defElementToken.getStringToken().contains(";")) {
                    remove = true;
                } else {
                    LiteralToken crtToken = defElementToken;
                    do {
                        if ((crtToken = this.getWSParser().getPrevToken(crtToken, path)) == null || !crtToken.getStringToken().contains(";")) continue;
                        remove = true;
                    } while (!remove && crtToken != null && !prevDefElementToken.equals(crtToken));
                }
                if (remove) {
                    this.elementsInCrtBlock.removeAll(this.elementsOnSameLine);
                    this.giveHits();
                    return;
                }
            }
        }
        if (lineNumber == this.prevLineNumber + 1) {
            this.elementsInCrtBlock.add(defElement);
            this.elementsOnSameLine.clear();
            int crtOffset = this.getOffsetOnLine(defElement, path);
            if (crtOffset > this.rightmostOffset) {
                this.rightmostOffset = crtOffset;
            }
        }
        this.prevLineNumber = lineNumber;
        this.prevDefElement = defElement;
    }

    private void giveHits() {
        if (this.elementsInCrtBlock == null || this.elementsInCrtBlock.isEmpty()) {
            return;
        }
        if (this.elementsInCrtBlock.size() == 1) {
            this.elementsInCrtBlock.clear();
            this.elementsOnSameLine.clear();
            return;
        }
        int noOfLineWithTab = -1;
        block0: for (RfDefElement defElement : this.elementsInCrtBlock) {
            int crtLine = defElement.getStartLine();
            ParserPath parserPath = defElement.getParserPath();
            if (parserPath == null) continue;
            for (LiteralToken token : this.getWSParser().getTokensOnLine(parserPath, defElement.getStartLine())) {
                if (token.getNoTabsBefore() <= 0) continue;
                noOfLineWithTab = crtLine;
                continue block0;
            }
        }
        for (RfDefElement defElement : this.elementsInCrtBlock) {
            Integer crtOffset;
            ParserPath parserPath = defElement.getParserPath();
            if (parserPath == null || (crtOffset = Integer.valueOf(this.getOffsetOnLine(defElement, parserPath))) == this.rightmostOffset) continue;
            this.addHit(parserPath, defElement.getStartLine(), "Variable '" + defElement.getName() + "' is not aligned inside the declaration block!", null, noOfLineWithTab != -1 ? new VerissimoAutofixAdditionalInfo(MessageFormat.format(AUTOFIX_ERROR_MESSAGE, noOfLineWithTab)) : new VerissimoAutofixAdditionalInfo(defElement, this.rightmostOffset));
        }
        this.elementsInCrtBlock.clear();
        this.elementsOnSameLine.clear();
    }

    private int getOffsetOnLine(RfDefElement element, ParserPath path) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            IDocument document = this.docManager.getDocument(path, this.getIProject());
            lineStartOffset = DVTDocumentUtils.convertLineToOffset((IDocument)document, (int)element.getStartLine());
            offsetOnLine = element.getStartOffset() - lineStartOffset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return docManager;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.projectVariablesMap != null) {
            this.projectVariablesMap.clear();
        }
    }
}

