/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_25;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;

@CheckVersion(value="20.1.31")
@CheckID(value="SVTB.1.1.25")
@CheckName(value="SVTB.1.1.25")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONDITIONAL, RuleLabel.LOOP, RuleLabel.PARENTHESIS})
@CheckTitle(value="Space between procedural statements and open parenthesis")
@CheckDescription(value="This rule checks there is at least one space character between if, for, while, case, repeat, foreach and open parenthesis.\nProcedural statements inside macro definitions are not checked.\n\nExamples:\nwhile (x == 0) // allowed\nwhile(x == 0) // not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_25.class)
public class Check_SVTB_1_1_25
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="false", description="When true, inactive code regions are also checked.", name="checkInactiveCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckInactiveCode;
    public static final String IF_STRING = "if";
    public static final String FOR_STRING = "for";
    public static final String WHILE_STRING = "while";
    public static final String CASE_STRING = "case";
    public static final String REPEAT_STRING = "repeat";
    public static final String FOREACH_STRING = "foreach";
    public static final String CASEZ_STRING = "casez";
    public static final String CASEX_STRING = "casex";
    private Set<String> allOperators = new HashSet<String>(Arrays.asList("if", "for", "while", "case", "foreach", "repeat", "casez", "casex"));
    private DocumentManager documentManager;

    public Check_SVTB_1_1_25(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public boolean isCheckedOperator(RfHidOperator operator) {
        return operator.isCaseCondition() || operator.isIfCondition() || operator.isWhileCondition() || operator.isRepeatCondition() || operator.isForeachCondition();
    }

    @Override
    public void performCheckImpl() {
        this.documentManager = new DocumentManager(true);
        LocalHidOperatorVisitor visitor = new LocalHidOperatorVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        try {
            this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    if (!(namedElement instanceof RfAbstractBlock)) {
                        return true;
                    }
                    Check_SVTB_1_1_25.this.notifyCheckAlive();
                    RfAbstractBlock actionBlock = (RfAbstractBlock)namedElement;
                    if (actionBlock.getFile() == null) {
                        return true;
                    }
                    if (actionBlock.getDeclaration() == null || actionBlock.getDeclaration().getReparseInfo() != null) {
                        return true;
                    }
                    ParserPath parserPath = actionBlock.getFile().getParserPath();
                    String shortFileName = LintUtils.getFileShortName(parserPath.path);
                    if (Check_SVTB_1_1_25.this.fOVMProject.isOVMFile(shortFileName)) {
                        return true;
                    }
                    if (Check_SVTB_1_1_25.this.checkPreWaivers(parserPath)) {
                        return true;
                    }
                    if (actionBlock.isFor()) {
                        LiteralToken literalToken = Check_SVTB_1_1_25.this.getWSParser().getToken(actionBlock.getOffset(), parserPath);
                        LiteralToken nextToken = Check_SVTB_1_1_25.this.getWSParser().getNextToken(literalToken, parserPath);
                        int offset = actionBlock.getOffset();
                        int line = actionBlock.getLine();
                        if (offset > 0) {
                            --offset;
                        }
                        IDocument document = Check_SVTB_1_1_25.this.documentManager.getDocument(parserPath, Check_SVTB_1_1_25.this.getIProject());
                        int lineOffset = Check_SVTB_1_1_25.this.getOffsetOnLine(document, offset, line);
                        if (literalToken == null || nextToken == null) {
                            literalToken = Check_SVTB_1_1_25.this.getWSParser().getTokenContainingOffset(actionBlock.getOffset(), parserPath);
                            nextToken = Check_SVTB_1_1_25.this.getWSParser().getNextCodeToken(literalToken, parserPath);
                            if (literalToken == null || nextToken == null) {
                                return true;
                            }
                            if (literalToken.getStringToken().contains("for(") || literalToken.getStringToken().endsWith(Check_SVTB_1_1_25.FOR_STRING) && literalToken.getNoSpacesAfter() == 0 && nextToken.getNoSpacesBefore() == 0 && nextToken.getStringToken().startsWith("(")) {
                                Check_SVTB_1_1_25.this.addHit(parserPath, line, "No space between 'for' and open parenthesis at line offset " + lineOffset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
                            }
                            return true;
                        }
                        String tokenString = literalToken.getStringToken();
                        int tokenLine = literalToken.getLineNumber();
                        if (!tokenString.startsWith(Check_SVTB_1_1_25.FOR_STRING)) {
                            while (!(literalToken == null || literalToken.getStringToken().startsWith(Check_SVTB_1_1_25.FOR_STRING) && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE || literalToken.getLineNumber() != tokenLine)) {
                                literalToken = Check_SVTB_1_1_25.this.getWSParser().getPrevToken(literalToken, parserPath);
                                nextToken = Check_SVTB_1_1_25.this.getWSParser().getPrevToken(nextToken, parserPath);
                            }
                        }
                        if (literalToken == null) {
                            return true;
                        }
                        tokenString = literalToken.getStringToken();
                        if (!tokenString.startsWith(Check_SVTB_1_1_25.FOR_STRING)) {
                            return true;
                        }
                        if (tokenString == null || !tokenString.equals(Check_SVTB_1_1_25.FOR_STRING)) {
                            Check_SVTB_1_1_25.this.addHit(parserPath, literalToken.getLineNumber(), "No space between 'for' and open parenthesis at line offset " + lineOffset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
                        } else if (literalToken.getNoSpacesAfter() == 0) {
                            while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                                nextToken = Check_SVTB_1_1_25.this.getWSParser().getNextToken(nextToken, parserPath);
                            }
                            if (nextToken == null || nextToken.getNoSpacesBefore() == 0) {
                                Check_SVTB_1_1_25.this.addHit(parserPath, literalToken.getLineNumber(), "No space between 'for' and open parenthesis at line offset " + lineOffset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.documentManager.deactivate();
        if (this.pCheckInactiveCode) {
            Map<ParserPath, CodePreprocFileInfo> codePreprocFileInfos = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos();
            for (Map.Entry<ParserPath, CodePreprocFileInfo> codePreprocFileInfoEntry : codePreprocFileInfos.entrySet()) {
                TreeSet<Integer> lines;
                CodePreprocFileInfo preprocInfo;
                ParserPath path = codePreprocFileInfoEntry.getKey();
                if (path == null || this.checkPreWaivers(path) || (preprocInfo = codePreprocFileInfoEntry.getValue()) == null || (lines = preprocInfo.getLines()) == null || lines.isEmpty()) continue;
                Iterator<Integer> iterator = lines.iterator();
                int line1 = 0;
                int line2 = 0;
                if (iterator.hasNext()) {
                    line2 = iterator.next();
                }
                while (iterator.hasNext()) {
                    line1 = line2;
                    line2 = iterator.next();
                    CodePreprocLineInfo info = preprocInfo.getInfo(line1);
                    if (info.getType() == 0) continue;
                    boolean isInsideInactiveMacro = false;
                    int currentLine = line1;
                    while (currentLine <= line2) {
                        for (LiteralToken token : this.getWSParser().getTokensOnLine(path, currentLine)) {
                            for (String operator : this.allOperators) {
                                char ch;
                                int start;
                                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE || isInsideInactiveMacro) continue;
                                if (token.getStringToken().endsWith("`define")) {
                                    isInsideInactiveMacro = true;
                                }
                                if (token.getStringToken().contains(String.valueOf(operator) + "(")) {
                                    start = token.getStringToken().indexOf(String.valueOf(operator) + "(");
                                    if (start == 0) {
                                        this.addHit(path, token.getLineNumber(), "No space between '" + operator + "' and open parenthesis at line offset " + token.getOffsetLine() + "!", null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                                        break;
                                    }
                                    char ch2 = token.getStringToken().charAt(start - 1);
                                    if (Character.isJavaIdentifierPart(ch2) || ch2 == '`') break;
                                    this.addHit(path, token.getLineNumber(), "No space between '" + operator + "' and open parenthesis at line offset " + token.getOffsetLine() + "!", null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                                    break;
                                }
                                if (!token.getStringToken().contains(operator) || token.getNoSpacesAfter() != 0) continue;
                                start = token.getStringToken().indexOf(operator);
                                if (start != 0 && (Character.isJavaIdentifierPart(ch = token.getStringToken().charAt(start - 1)) || ch == '`')) break;
                                LiteralToken nextToken = this.getWSParser().getNextToken(token, path);
                                while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                                    nextToken = this.getWSParser().getNextToken(nextToken, path);
                                }
                                if (nextToken != null && (!nextToken.getStringToken().startsWith("(") || nextToken.getNoSpacesBefore() != 0)) break;
                                this.addHit(path, token.getLineNumber(), "No space between '" + operator + "' and open parenthesis at line offset " + token.getOffsetLine() + "!", null, new VerissimoAutofixAdditionalInfo(token.getOffsetFile()));
                                break;
                            }
                            if (!isInsideInactiveMacro || !token.isLastTokenOnLine() || token.getStringToken().endsWith("\\")) continue;
                            isInsideInactiveMacro = false;
                        }
                        ++currentLine;
                    }
                }
            }
        }
    }

    private int getOffsetOnLine(IDocument document, int offset, int line) {
        int lineStartOffset = 0;
        int offsetOnLine = 0;
        try {
            lineStartOffset = document.getLineOffset(line - 1);
            offsetOnLine = offset - lineStartOffset + 2;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return offsetOnLine;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator operator) {
            if (operator.getOperatorText() == null) {
                return true;
            }
            Check_SVTB_1_1_25.this.notifyCheckAlive();
            if (operator.isHidden()) {
                return true;
            }
            if (!Check_SVTB_1_1_25.this.isCheckedOperator(operator)) {
                return true;
            }
            if (operator.getReparseInfo() != null) {
                return true;
            }
            String shortFileName = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_SVTB_1_1_25.this.fOVMProject.isOVMFile(shortFileName)) {
                return true;
            }
            if (Check_SVTB_1_1_25.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            String operatorText = operator.getOperatorText();
            if (operatorText == null) {
                return true;
            }
            LiteralToken literalToken = Check_SVTB_1_1_25.this.getWSParser().getToken(operator.getOccurrence().getOffset(), this.parserPath);
            LiteralToken prevToken = Check_SVTB_1_1_25.this.getWSParser().getPrevToken(literalToken, this.parserPath);
            int offset = operator.getOccurrence().getOffset();
            int line = operator.getOccurrence().getLine();
            if (offset > 0) {
                --offset;
            }
            if (literalToken != null && prevToken != null && literalToken.getStringToken().charAt(0) != '(') {
                return true;
            }
            IDocument document = Check_SVTB_1_1_25.this.documentManager.getDocument(this.parserPath, Check_SVTB_1_1_25.this.getIProject());
            int lineOffset = Check_SVTB_1_1_25.this.getOffsetOnLine(document, offset, line);
            if (literalToken == null || prevToken == null) {
                Check_SVTB_1_1_25.this.addHit(this.parserPath, operator.getOccurrence().getLine(), "No space between '" + operator.getOperatorText() + "' and open parenthesis at line offset " + lineOffset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
            } else if (literalToken.getNoSpacesBefore() == 0) {
                while (prevToken != null && prevToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                    prevToken = Check_SVTB_1_1_25.this.getWSParser().getPrevToken(prevToken, this.parserPath);
                }
                if (prevToken == null || !operatorText.equals(prevToken.getStringToken()) || prevToken.getNoSpacesAfter() == 0) {
                    Check_SVTB_1_1_25.this.addHit(this.parserPath, operator.getOccurrence().getLine(), "No space between '" + operator.getOperatorText() + "' and open parenthesis at line offset " + lineOffset + "!", null, new VerissimoAutofixAdditionalInfo(offset));
                }
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

