/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_26;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractIndentationCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.1.1.26")
@CheckName(value="SVTB.1.1.26")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.INDENTATION})
@CheckTitle(value="Begin-end blocks indentation ")
@CheckDescription(value="This rule checks the indentation inside action blocks.\nThe indentation of a line must be increased by exactly <numberOfWhitespaces> compared to the indentation of the enclosing block.\n\nExamples for numberOfWhitespaces = 2:\nwhile (cnt < 5)\n  cnt++;// allowed\n\nwhile (cnt < 5)\n   cnt++;// not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_1_26.class)
public class Check_SVTB_1_1_26
extends AbstractIndentationCheck {
    public Check_SVTB_1_1_26(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean isBlockStart(LiteralToken literalToken, ParserPath path) {
        String token;
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        Object object = this.operatorsStrings;
        int n = this.operatorsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            token = object[n2];
            if (text.equals(token) || text.startsWith(String.valueOf(token) + "(")) {
                return true;
            }
            ++n2;
        }
        object = this.alwaysStrings;
        n = this.alwaysStrings.length;
        n2 = 0;
        while (n2 < n) {
            token = object[n2];
            if (text.equals(token) || text.startsWith(String.valueOf(token) + "@")) {
                return true;
            }
            ++n2;
        }
        if (this.pIndentInsideConditionalCompilerDirectives) {
            LiteralToken nextToken = this.getWSParser().getNextToken(literalToken, path);
            String tokenAndPrevTokenString = literalToken.toString();
            if (nextToken != null) {
                tokenAndPrevTokenString = String.valueOf(tokenAndPrevTokenString) + nextToken.toString();
            }
            for (String token2 : this.openCompilerDirectives) {
                if (!text.equals(token2) && !tokenAndPrevTokenString.equals(token2) && !text.endsWith(token2) && !tokenAndPrevTokenString.endsWith(token2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isConditionStart(LiteralToken literalToken, ParserPath path) {
        LiteralToken prevToken;
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        if (this.conditionOperatorsStrings.contains(text)) {
            return true;
        }
        for (String token : this.conditionOperatorsStrings) {
            if (!text.startsWith(String.valueOf(token) + "(")) continue;
            return true;
        }
        return (text.equals("property") || text.startsWith("property(")) && (prevToken = this.getWSParser().getPrevCodeToken(literalToken, path)) != null && prevToken.getStringToken().endsWith("assert");
    }

    @Override
    protected boolean reachedConditionEnd(LiteralToken currentToken, LiteralToken conditionStartToken, int paranthesesBalance) {
        if (conditionStartToken == null) {
            return false;
        }
        String text = currentToken.getStringToken();
        return paranthesesBalance + this.countTokenParanthesesBalance(currentToken) == 0 && !this.conditionOperatorsStrings.contains(text) && !"property".equals(text);
    }

    @Override
    protected boolean checkOtherEndBlocks(String token, LiteralToken literalToken) {
        return (token.equals("endcase") || token.startsWith("join") || token.startsWith("}")) && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE;
    }

    @Override
    protected boolean nextOffsetCondition(int offsetIndex, List<AbstractIndentationCheck.Offset> fileBlockOffsets, LiteralToken literalToken) {
        return offsetIndex + 1 < fileBlockOffsets.size() && literalToken.getOffsetFile() > fileBlockOffsets.get((int)(offsetIndex + 1)).elementOffset;
    }

    @Override
    protected boolean startFromZero() {
        return false;
    }

    @Override
    protected int otherEndBlocksindentation(int currentBlockIndentation) {
        return currentBlockIndentation - this.pNumberOfWhitespaces;
    }

    @Override
    protected int adjustEndForActionBlock(int end, RfActionBlock actionBlock) {
        return end;
    }
}

