/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_1_2_0;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="16.1.6")
@CheckID(value="SVTB.1.1.2.0")
@CheckName(value="SVTB.1.1.2.0")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.INDENTATION})
@CheckTitle(value="Use a specified number of spaces for indentation")
@CheckDescription(value="This rule checks that each line starts with a number of spaces multiple of 'nofSpaces'.\n\nExamples for nofSpaces = 2:\n\nboo(a, b, c); // allowed\n moo = {a, b, c}; // not allowed\n  boo(a,b,c); // allowed\n   moo = {a,b,c}; // not allowed\n    string too = \"1,885\" // allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_1_1_2_0.class)
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", defaultValue="1"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
public class Check_SVTB_1_1_2_0
extends AbstractSVTBSimpleIssues {
    private static final String FAIL_MESSAGE_FORMAT = "Number of spaces used for indentation is not multiple of {0}!{1}";
    @CheckParameter(defaultValue="false", description="Show scope information, useful for waiving.", name="showScopeInfo", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pShowScopeInfoValue;
    @CheckParameter(defaultValue="4", description="The number of spaces used for indentation. When set to 0 the value is automatically set for each file based on the first indentation detected in that file.", name="nofSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pNofSpacesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of prefixes. If a line begins with such a prefix its indentation will not be checked.", name="skipLinesWithPrefix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipLinesWithPrefix;
    @CheckParameter(defaultValue="", description="Comma separated list of suffixes. If a line ends with such a suffix the indentation of the next line with code will not be checked.", name="skipLinesWithPreviousLineSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipLinesWithPreviousLineSuffix;
    @CheckParameter(defaultValue="true", description="Block comments or single line comments will be skipped.", name="skipComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipComments;
    @CheckParameter(defaultValue="false", description="Skip lines that contain vertically alligned lines.", name="skipVerticallyAlignedLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipVerticallyAlignedLines;

    public Check_SVTB_1_1_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(43);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        if (issue != null) {
            return issue.getMessageForHit();
        }
        return MessageFormat.format(FAIL_MESSAGE_FORMAT, this.pNofSpacesValue, "");
    }

    private List<Integer> getFilteredLines(ParserPath filename, int offset, List<Integer> visitedScopesOffsets) {
        RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename);
        if (fileDef == null) {
            return null;
        }
        RfDefElement defScope = fileDef.getScope(offset, true);
        if (defScope == null || visitedScopesOffsets.contains(defScope.getStartOffset())) {
            return null;
        }
        RfNamedElement namedElement = defScope.getNamedElement();
        if (!(namedElement instanceof RfFunction || namedElement instanceof RfModule || namedElement instanceof RfInterface || namedElement instanceof RfClass)) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (namedElement instanceof RfFunction) {
            List<RfField> arguments = namedElement.getArgumentsWithPrefix("", 2);
            if (arguments.size() < 2 || !(defScope instanceof RfFunctionDef) || !((RfFunctionDef)defScope).isANSIStyle()) {
                return null;
            }
            if (namedElement.isExtern()) {
                if (visitedScopesOffsets.contains(namedElement.getOffset())) {
                    return null;
                }
                ArrayList fieldsList = new ArrayList();
                fieldsList.add(new ArrayList());
                fieldsList.add(new ArrayList());
                for (RfField argument : arguments) {
                    RfDefElement implementation;
                    RfDefElement declaration = argument.getDeclaration();
                    if (declaration != null) {
                        ((List)fieldsList.get(0)).add(new Pair(declaration.getStartOffset(), declaration.getStartLine()));
                    }
                    if ((implementation = argument.getImplementation()) == null) continue;
                    ((List)fieldsList.get(1)).add(new Pair(implementation.getStartOffset(), implementation.getStartLine()));
                }
                result.addAll(this.checkParametersLines(filename, (List)fieldsList.get(0)));
                result.addAll(this.checkParametersLines(filename, (List)fieldsList.get(1)));
            } else {
                result.addAll(this.checkParametersLines(filename, arguments.stream().map(x -> new Pair(x.getOffset(), x.getLine())).collect(Collectors.toList())));
            }
        }
        if (namedElement instanceof RfClass || namedElement instanceof RfModule || namedElement instanceof RfInterface) {
            result.addAll(this.checkParametersLines(filename, namedElement.getLocalParameters(384).stream().filter(RfField::isInParameterPortList).map(x -> new Pair(x.getOffset(), x.getLine())).collect(Collectors.toList())));
        }
        if (namedElement instanceof RfModule || namedElement instanceof RfInterface) {
            result.addAll(this.checkParametersLines(filename, namedElement.getPortsWithPrefix("", 0).stream().map(x -> new Pair(x.getOffset(), x.getLine())).collect(Collectors.toList())));
        }
        visitedScopesOffsets.add(defScope.getStartOffset());
        return result;
    }

    private List<Integer> checkParametersLines(ParserPath filename, List<Pair> arguments) {
        if (arguments.size() < 2 || arguments.get(0).getLine() == arguments.get(1).getLine()) {
            return new ArrayList<Integer>();
        }
        HashSet<Integer> indentations = new HashSet<Integer>();
        for (Pair argument : arguments) {
            indentations.add(this.getWSParser().getTokenContainingOffset(argument.getOffset(), filename).getOffsetLine());
        }
        if (indentations.size() != 1) {
            return new ArrayList<Integer>();
        }
        return arguments.stream().map(x -> x.getLine()).collect(Collectors.toList());
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> allRuleIssues = new HashMap<ParserPath, List<SVTBIssues>>();
        if (this.pNofSpacesValue == 0) {
            HashSet<ParserPath> fileNames = this.fOVMProject.getAllImportedFiles();
            try {
                for (ParserPath fileName : fileNames) {
                    if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileName, this)) continue;
                    this.notifyCheckAlive();
                    int nofSpaces = this.getNofSpacesUsedAsIndentation(fileName.path);
                    if (nofSpaces == 0 || nofSpaces == 1) continue;
                    HashSet<Integer> nofSpacesSet = new HashSet<Integer>();
                    nofSpacesSet.add(nofSpaces);
                    HashSet<ParserPath> singleFile = new HashSet<ParserPath>();
                    singleFile.add(fileName);
                    Map<ParserPath, List<SVTBIssues>> allCharIssues = SVTBCharParser.getAllCharIssues(this.fOVMProject, singleFile, new SVTBCharParser.Config(nofSpacesSet, this.pSkipLinesWithPrefix, this.pSkipLinesWithPreviousLineSuffix, this.pSkipComments), this);
                    Map<ParserPath, List<SVTBIssues>> issues = this.fOVMProject.filterSVTBIssuesByKind(allCharIssues, 43, new int[0]);
                    if (issues.get(fileName) == null) continue;
                    ArrayList<Integer> filteredOffsets = new ArrayList<Integer>();
                    ArrayList<Integer> visitedScopesOffsets = new ArrayList<Integer>();
                    for (SVTBIssues issue : issues.get(fileName)) {
                        List<Integer> filteredHitLines;
                        if (this.pSkipVerticallyAlignedLines && (filteredHitLines = this.getFilteredLines(fileName, issue.getOffset(), visitedScopesOffsets)) != null) {
                            filteredOffsets.addAll(filteredHitLines);
                        }
                        if (filteredOffsets.contains(issue.getLine())) continue;
                        issue.setMessageForHit(MessageFormat.format(FAIL_MESSAGE_FORMAT, nofSpaces, ""));
                    }
                    allRuleIssues.put(fileName, issues.get(fileName));
                }
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else {
            HashSet<Integer> nofSpacesSet = new HashSet<Integer>();
            nofSpacesSet.add(this.pNofSpacesValue);
            Map<ParserPath, List<SVTBIssues>> allWhitespaceIssues = this.fOVMProject.getSVTBCharIssuesWithKind(new SVTBCharParser.Config(nofSpacesSet, this.pSkipLinesWithPrefix, this.pSkipLinesWithPreviousLineSuffix, this.pSkipComments), 43, this);
            for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allWhitespaceIssues.entrySet()) {
                ParserPath filename = entry.getKey();
                ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
                ArrayList<Integer> filteredOffsets = new ArrayList<Integer>();
                ArrayList<Integer> visitedScopesOffsets = new ArrayList<Integer>();
                for (SVTBIssues issue : entry.getValue()) {
                    List<Integer> filteredHitLines;
                    if (this.pSkipVerticallyAlignedLines && (filteredHitLines = this.getFilteredLines(filename, issue.getOffset(), visitedScopesOffsets)) != null) {
                        filteredOffsets.addAll(filteredHitLines);
                    }
                    if (DVTStringUtil.parseInt((String)issue.getInfo(), (int)0) != this.pNofSpacesValue || filteredOffsets.contains(issue.getLine())) continue;
                    issue.setMessageForHit(MessageFormat.format(FAIL_MESSAGE_FORMAT, this.pNofSpacesValue, ""));
                    filteredList.add(issue);
                }
                allRuleIssues.put(filename, filteredList);
            }
        }
        if (!this.pShowScopeInfoValue) {
            return allRuleIssues;
        }
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Set keySet = allRuleIssues.keySet();
        for (ParserPath filename : keySet) {
            List issues;
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename);
            if (filedef == null || (issues = (List)allRuleIssues.get(filename)) == null || issues.isEmpty()) continue;
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                issue.setMessageForHit(String.valueOf(issue.getMessageForHit()) + " Scope: [" + LintUtils.getScopeDetails(this.fOVMProject.getRfProject(), filename, issue.getOffset()) + "]");
                filteredList.add(issue);
            }
            filteredMap.put(filename, filteredList);
        }
        return filteredMap;
    }

    private int getNofSpacesUsedAsIndentation(String path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            int nofSpaces = 0;
            boolean countBeginSpaces = true;
            boolean inBlockComment = false;
            boolean inLineComment = false;
            boolean skip = false;
            int c = 0;
            char c2 = (char)reader.read();
            char c1 = '\u0000';
            while ((c = reader.read()) != -1) {
                c1 = c2;
                c2 = (char)c;
                if (countBeginSpaces) {
                    if (c1 == ' ') {
                        ++nofSpaces;
                    } else {
                        countBeginSpaces = false;
                    }
                }
                if (skip) {
                    skip = false;
                    if (c1 != '\n') continue;
                    countBeginSpaces = true;
                    continue;
                }
                if (c1 == '\n') {
                    countBeginSpaces = true;
                    inLineComment = false;
                    nofSpaces = 0;
                    continue;
                }
                if (c1 == '\r') {
                    if (c2 == '\n') {
                        skip = true;
                    }
                    countBeginSpaces = true;
                    inLineComment = false;
                    nofSpaces = 0;
                    continue;
                }
                if (c1 == '/' && c2 == '/' && !inBlockComment && !inLineComment) {
                    inLineComment = true;
                    skip = true;
                    nofSpaces = 0;
                    continue;
                }
                if (c1 == '/' && c2 == '*' && !inLineComment && !inBlockComment) {
                    inBlockComment = true;
                    skip = true;
                    nofSpaces = 0;
                    continue;
                }
                if (c1 == '*' && c2 == '/' && !inLineComment && inBlockComment) {
                    inBlockComment = false;
                    skip = true;
                    continue;
                }
                if (c != 32 && !inLineComment && !inBlockComment && !countBeginSpaces && nofSpaces > 0) break;
            }
            return nofSpaces;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class Pair {
        int offset;
        int line;

        public Pair(int offset, int line) {
            this.offset = offset;
            this.line = line;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }
    }
}

