/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.1.3")
@CheckName(value="SVTB.1.1.3")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.COMMENT})
@CheckTitle(value="Multi-line comment length")
@CheckDescription(value="A multi-line comment should not exceed 'maxNofChars' per line.\n\nExamples for maxNofChars = 8:\n\n/* abcabcabc */ // not allowed\n/* abcde */ //  allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_1_1_3
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="80", description="Maximum number of characters per line.", name="maxNofChars", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pMaxNofCharsValue;

    public Check_SVTB_1_1_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(26);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Comment line has more than " + this.pMaxNofCharsValue + " characters!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBCharIssuesWithKind(new SVTBCharParser.Config(this.pMaxNofCharsValue), 26, this);
    }
}

