/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.5.34")
@CheckID(value="SVTB.1.1.4")
@CheckName(value="SVTB.1.1.4")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Max line length")
@CheckDescription(value="A line should not exceed 'maxNofChars'.\n\nExamples for maxNofChars = 15:\n\nint x = 100 + a + b + c; // not allowed\nint x = 100 \n+ a + b + c; //  allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_1_1_4
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="120", description="Maximum number of characters per line.", name="maxNofChars", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pMaxNofCharsValue;
    @CheckParameter(defaultValue="true", description="Allow long lines caused by in-line or block comments.", name="allowLongComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowLongCommentsValue;
    @CheckParameter(defaultValue="true", description="Allow long lines caused by linter pragma waivers.", name="allowPragmaWaivers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowPragmaWaivers;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed long lines patterns.", name="allowedPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pAllowLinesWithPattern;

    public Check_SVTB_1_1_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(127);
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBCharIssuesWithKind(new SVTBCharParser.Config(this.pMaxNofCharsValue, this.pAllowLongCommentsValue, this.pAllowPragmaWaivers, this.pAllowLinesWithPattern), 127, this);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Line has " + issue.getInfo() + " characters. It exceeds max " + this.pMaxNofCharsValue + " characters!";
    }
}

