/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="16.1.17")
@CheckID(value="SVTB.1.1.7")
@CheckName(value="SVTB.1.1.7")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.FILE, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Max number of lines per file")
@CheckDescription(value="A file should not exceed 'maxNofLines'.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_1_1_7
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="400", description="Maximum number of lines per file.", name="maxNofLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pMaxNofLinesValue;

    public Check_SVTB_1_1_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(501);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "File has " + issue.getLine() + " lines. " + "It exceeds max " + this.pMaxNofLinesValue + " lines!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBCharIssuesWithKind(new SVTBCharParser.Config(false, this.pMaxNofLinesValue), 501, this);
    }
}

