/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="17.1.44")
@CheckID(value="SVTB.1.1.9")
@CheckName(value="SVTB.1.1.9")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="No whitespace between hierarchical identifiers")
@CheckDescription(value="Do not use whitespace between hierarchical identifiers.\n\nExamples:\n\nfield_a.field_b.field_a.value = 1; // allowed\nfield_a.field_b.field_a. value = 1; // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_1_9
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="false", description="When true, indentation whitespace from start of line to identifier is allowed when hierarchical identifiers are split on multiple lines", name="allowIndentationOfMultilineHierarchicalIdentifiers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowIndentationOfMultilineHierarchicalIdentifiers;
    @CheckParameter(defaultValue="false", description="When true, one whitespace after escaped identifiers will not be flagged for the next hierarchical identifier", name="allowWhitespaceAfterEscapedIdentifiers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowWhitespaceAfterEscapedIdentifiers;
    private static final char DOT_ACCESS = '.';
    private static final String DOT_ACCESS_STRING = ".";
    private static final char BACKSLASH = '\\';
    private static final boolean checkBefore = true;
    private static final boolean checkAfter = false;
    public static final Pattern removeStringsPattern = Pattern.compile("\"([^\"]*)\"");

    public Check_SVTB_1_1_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashMap<ParserPath, Map<HidOccurrence, RfHid>> accessedHids = new HashMap<ParserPath, Map<HidOccurrence, RfHid>>();
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHidAccess>(){
            ParserPath parserPath;

            public void setHolder(IHidHolder holder) {
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(RfHidAccess hidAccess) {
                if (Check_SVTB_1_1_9.this.pathIsPrewaived(this.parserPath)) {
                    return true;
                }
                if (hidAccess.getAccessKind() != 0) {
                    return true;
                }
                ListContainer hids = hidAccess.getHids();
                if (hids == null || hids.isEmpty()) {
                    return true;
                }
                for (Hid hid : hids) {
                    HidOccurrence occurrence;
                    if (!(hid instanceof RfHid) || hid.getName().equals("new") && !hid.getParentHid().getName().equals("super") && !hid.getParentHid().getName().equals("this")) continue;
                    RfHid rfHid = (RfHid)hid;
                    HashMap<HidOccurrence, RfHid> rfHids = (HashMap<HidOccurrence, RfHid>)accessedHids.get(this.parserPath);
                    if (rfHids == null) {
                        rfHids = new HashMap<HidOccurrence, RfHid>();
                    }
                    if ((occurrence = rfHid.getOccurrence()) != null) {
                        rfHids.put(occurrence, rfHid);
                    }
                    accessedHids.put(this.parserPath, rfHids);
                }
                return true;
            }

            public Class<RfHidAccess> getType() {
                return RfHidAccess.class;
            }
        });
        this.checkHidOccurrences(accessedHids);
    }

    private void checkHidOccurrences(Map<ParserPath, Map<HidOccurrence, RfHid>> accessedHids) {
        for (Map.Entry<ParserPath, Map<HidOccurrence, RfHid>> entry : accessedHids.entrySet()) {
            this.notifyCheckAlive();
            ParserPath path = entry.getKey();
            Map<HidOccurrence, RfHid> hidMap = entry.getValue();
            for (Map.Entry<HidOccurrence, RfHid> occurrenceEntry : hidMap.entrySet()) {
                HidOccurrence occurrence = occurrenceEntry.getKey();
                String hidName = occurrenceEntry.getValue().getName();
                ReparseInfo reparseInfo = (ReparseInfo)occurrence.getReparseInfo(ReparseInfo.class);
                if (reparseInfo != null) {
                    this.handleReparseInfo(reparseInfo, path, hidName, occurrence);
                    continue;
                }
                LiteralToken token = this.getWSParser().getTokenContainingOffset(occurrence.getOffset(), path);
                if (token == null || occurrence.getOffset() - token.getOffsetFile() > 1) continue;
                if (token.getStringToken().charAt(0) == '.') {
                    if (this.pAllowIndentationOfMultilineHierarchicalIdentifiers && (!this.pAllowIndentationOfMultilineHierarchicalIdentifiers || token.isFirstTokenOnLine()) || this.pAllowWhitespaceAfterEscapedIdentifiers && (!this.pAllowWhitespaceAfterEscapedIdentifiers || !this.exceedsNofSpacesBeforeOrAfter(token, path, true))) continue;
                    this.addHit(path, occurrence, "Whitespace used before dot access of '" + hidName + "'!");
                    continue;
                }
                LiteralToken prevToken = this.getWSParser().getPrevToken(token, path);
                if (prevToken.getStringToken().equals(DOT_ACCESS_STRING)) {
                    if ((!this.pAllowIndentationOfMultilineHierarchicalIdentifiers || this.pAllowIndentationOfMultilineHierarchicalIdentifiers && !prevToken.isFirstTokenOnLine()) && (!this.pAllowWhitespaceAfterEscapedIdentifiers || this.pAllowWhitespaceAfterEscapedIdentifiers && this.exceedsNofSpacesBeforeOrAfter(prevToken, path, true))) {
                        this.addHit(path, occurrence, "Whitespace used before dot access of '" + (token.getStringToken().charAt(0) == '\\' ? Character.valueOf('\\') : "") + hidName + "'!");
                    }
                    if ((!this.pAllowIndentationOfMultilineHierarchicalIdentifiers || this.pAllowIndentationOfMultilineHierarchicalIdentifiers && !prevToken.isLastTokenOnLine()) && this.exceedsNofSpacesBeforeOrAfter(token, path, false)) {
                        this.addHit(path, occurrence, "Whitespace used after dot access of '" + (token.getStringToken().charAt(0) == '\\' ? Character.valueOf('\\') : "") + hidName + "'!");
                    }
                }
                if (prevToken.getStringToken().charAt(prevToken.getStringToken().length() - 1) != '.' || prevToken.getLength() <= 1 || this.pAllowIndentationOfMultilineHierarchicalIdentifiers && (!this.pAllowIndentationOfMultilineHierarchicalIdentifiers || token.getLineNumber() != prevToken.getLineNumber()) || !this.exceedsNofSpacesBeforeOrAfter(token, path, false)) continue;
                this.addHit(path, occurrence, "Whitespace used after dot access of '" + (token.getStringToken().charAt(0) == '\\' ? Character.valueOf('\\') : "") + hidName + "'!");
            }
        }
    }

    private void handleReparseInfo(ReparseInfo reparseInfo, ParserPath path, String hidName, HidOccurrence occurrence) {
        ReparseInfo.ReparseElement[] reparseElements;
        Pattern afterPattern = null;
        afterPattern = !this.pAllowIndentationOfMultilineHierarchicalIdentifiers ? Pattern.compile("\\.\\s+" + hidName) : Pattern.compile("\\.[\\t ]+" + hidName);
        Pattern beforePattern = null;
        beforePattern = !this.pAllowIndentationOfMultilineHierarchicalIdentifiers ? Pattern.compile("\\s+\\.\\s*" + hidName) : Pattern.compile("\\w+[\\t ]+\\.\\s*" + hidName);
        ReparseInfo.ReparseElement[] reparseElementArray = reparseElements = reparseInfo.getReparseStack();
        int n = reparseElements.length;
        int n2 = 0;
        while (n2 < n) {
            String[] params;
            ReparseInfo.ReparseElement reparseElement = reparseElementArray[n2];
            String[] stringArray = params = reparseElement.getReparseMacroParams();
            int n3 = params.length;
            int n4 = 0;
            while (n4 < n3) {
                Matcher mb;
                String param = stringArray[n4];
                Matcher m = removeStringsPattern.matcher(param);
                String paramCopy = m.replaceAll("");
                Matcher ma = afterPattern.matcher(paramCopy);
                if (ma.find()) {
                    this.addHit(path, occurrence.getLine(), "Whitespace used after dot access of '" + hidName + "'!", null);
                }
                if ((mb = beforePattern.matcher(paramCopy)).find()) {
                    this.addHit(path, occurrence.getLine(), "Whitespace used before dot acess of '" + hidName + "'!", null);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private boolean exceedsNofSpacesBeforeOrAfter(LiteralToken token, ParserPath path, boolean check) {
        int spaces = token.getNoSpacesBefore() + token.getNoTabsBefore();
        if (check) {
            LiteralToken prevToken = this.getWSParser().getPrevToken(token, path);
            return prevToken.getStringToken().charAt(0) != '\\' || spaces > 1 || token.isFirstTokenOnLine();
        }
        return spaces > 0 || token.isFirstTokenOnLine();
    }
}

