/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_4_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSingleStatementCheck;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.4.1")
@CheckName(value="SVTB.1.4.1")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="One statement per line")
@CheckDescription(value="Write only one statement per line.\n\nExamples:\n\n   myint = 5; mybit = 1'b1; myfoo = 3.5; // NOT ALLOWED\n\n   if (foo) begin // allowed\n   ...\n   else if(moo) // allowed exception\n\n   if (foo) bar = 1; // allowed IFF allowSameLine\n\n   while(foo) bar = 1; // allowed IFF allowSameLine\n\n   do bar = 1; while(foo); // allowed IFF allowSameLine\n\n   fork foo(); join // allowed IFF allowSameLine\n\n   assert (A == B) else $fatal; // allowed IFF allowSameLine\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="allowedKeywords", defaultValue="if, for, foreach, forever, while, repeat, do, fork, assert, else"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_4_1.class)
public class Check_SVTB_1_4_1
extends AbstractSingleStatementCheck {
    private static final Set<String> timeControlOperators = new HashSet<String>(Arrays.asList("@", "#", "##"));
    private Set<String> allowedKeywordsValues = new HashSet<String>(Arrays.asList("if", "for", "foreach", "forever", "while", "repeat", "do", "fork", "assert", "else", "wait"));
    @CheckParameter(defaultValue="true", description="Don't check inside macros.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosValue;
    @CheckParameter(defaultValue="true", description="Don't flag macros on same line.", name="skipMacrosSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosSameLine;
    @CheckParameter(defaultValue="false", description="Allow <allowedKeywords> exceptions.", name="allowSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSameLineValue;

    public Check_SVTB_1_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String allowedKeyword : this.pAllowedKeywords) {
            if (this.allowedKeywordsValues.contains(allowedKeyword)) continue;
            this.signalParamError("Keyword '" + allowedKeyword + "' specified for `allowedKeywords` is not allowed!", true);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(114);
    }

    @Override
    public void performCheckImpl() {
        this.docManager = this.getDocumentManager();
        Map<ParserPath, DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>> allIssues = this.getSVTBIssuesPairs();
        block0: for (Map.Entry<ParserPath, DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>> entry : allIssues.entrySet()) {
            List issuesForce;
            int hitCounterPerFile = 0;
            ParserPath parserPath = entry.getKey();
            List issues = (List)entry.getValue().getKey();
            if (issues != null) {
                for (DVTPair issue : issues) {
                    OVMComplianceHit hit = null;
                    hit = this.addHit(parserPath, ((SVTBIssues)issue.getKey()).getLine(), this.getFailMessage((SVTBIssues)issue.getKey(), parserPath), ((SVTBIssues)issue.getKey()).getReparseInfo(), this.isForceFailure(((SVTBIssues)issue.getKey()).getReparseInfo()), this.getVerissimoAutofixAdditionalInfo((SVTBIssues)issue.getKey(), (SVTBIssues)issue.getValue()), this.isHidden(hitCounterPerFile));
                    if (hit != null) {
                        ++hitCounterPerFile;
                    }
                    if (this.reachedMaxHitCountInFile(hitCounterPerFile)) break;
                }
            }
            if ((issuesForce = (List)entry.getValue().getValue()) == null) continue;
            for (DVTPair issue : issuesForce) {
                OVMComplianceHit hit = null;
                hit = this.addHit(parserPath, ((SVTBIssues)issue.getKey()).getLine(), this.getFailMessageBetweenMacros((SVTBIssues)issue.getKey(), parserPath), ((SVTBIssues)issue.getKey()).getReparseInfo(), true, this.getVerissimoAutofixAdditionalInfo((SVTBIssues)issue.getKey(), (SVTBIssues)issue.getValue()), this.isHidden(hitCounterPerFile));
                if (hit != null) {
                    ++hitCounterPerFile;
                }
                if (this.reachedMaxHitCountInFile(hitCounterPerFile)) continue block0;
            }
        }
        this.docManager.deactivate();
    }

    @Override
    protected String getFailMessage(SVTBIssues issue, ParserPath parserPath) {
        String info = issue.getInfo();
        String messageForHit = issue.getMessageForHit();
        IDocument document = this.docManager.getDocument(parserPath, this.getIProject());
        if (issue != null && messageForHit != null && info != null) {
            if (messageForHit.equals("Next line should be empty or contain only whitespaces!")) {
                return "Next line should be empty or contain only whitespaces!";
            }
            return "More than one statement per line found at line offset " + this.getOffsetOnLine(document, issue) + ": '" + messageForHit + " - " + info + "'!";
        }
        return "More than one statement per line!";
    }

    protected String getFailMessageBetweenMacros(SVTBIssues issue, ParserPath parserPath) {
        String info = issue.getReparseInfo() != null && issue.getReparseInfo().getReparseStack() != null ? issue.getReparseInfo().getReparseStack()[0].getReparseMacroName() : issue.getInfo();
        String messageForHit = issue.getMessageForHit();
        IDocument document = this.docManager.getDocument(parserPath, this.getIProject());
        if (issue != null && messageForHit != null && info != null) {
            if (messageForHit.equals("Next line should be empty or contain only whitespaces!")) {
                return "Next line should be empty or contain only whitespaces!";
            }
            return "More than one statement per line found at line offset " + this.getOffsetOnLine(document, issue) + ": '" + messageForHit + " - " + info + "'!";
        }
        return "More than one statement per line!";
    }

    protected Map<ParserPath, DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>> getSVTBIssuesPairs() {
        HashMap<ParserPath, DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>> resultMap = new HashMap<ParserPath, DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>>();
        Map<ParserPath, List<SVTBIssues>> issues = this.fOVMProject.getSVTBIssuesWithKind(114);
        if (issues == null || issues.isEmpty()) {
            return resultMap;
        }
        Set<ParserPath> allFilenamesWithIssues = issues.keySet();
        for (ParserPath eachFilenameWithIssues : allFilenamesWithIssues) {
            List<SVTBIssues> uniqueIssuesInFile;
            RfFileDef fileDefWithIssues = this.fOVMProject.getRfProject().getFileDefUsingParserPath(eachFilenameWithIssues);
            if (fileDefWithIssues == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(eachFilenameWithIssues, this) || (uniqueIssuesInFile = issues.get(eachFilenameWithIssues)) == null || uniqueIssuesInFile.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<DVTPair> resultList = new ArrayList<DVTPair>();
            ArrayList<DVTPair> resultListForce = new ArrayList<DVTPair>();
            int size = uniqueIssuesInFile.size();
            int i = 0;
            while (i < size - 1) {
                SVTBIssues issue = uniqueIssuesInFile.get(i);
                if (!(this.pSkipMacrosValue && this.pSkipMacrosSameLine && this.insideMacro(issue))) {
                    SVTBIssues nextIssue = null;
                    int j = i + 1;
                    while (j < size) {
                        SVTBIssues svtbIssue = uniqueIssuesInFile.get(j);
                        if (!(this.pSkipMacrosValue && this.pSkipMacrosSameLine && this.insideMacro(svtbIssue))) {
                            i = j - 1;
                            nextIssue = svtbIssue;
                            break;
                        }
                        ++j;
                    }
                    if (nextIssue != null && this.isSameLine(issue, nextIssue)) {
                        String info = issue.getInfo();
                        String nextInfo = nextIssue.getInfo();
                        ReparseInfo reparseInfo = issue.getReparseInfo();
                        ReparseInfo nextReparseInfo = nextIssue.getReparseInfo();
                        if (!this.pSkipMacrosSameLine && (reparseInfo != null && nextReparseInfo != null || reparseInfo != null && nextReparseInfo == null || reparseInfo == null && nextReparseInfo != null)) {
                            String nextFirstMacroName;
                            ReparseInfo.ReparseElement[] macroStack = reparseInfo != null ? reparseInfo.getReparseStack() : null;
                            String firstMacroName = macroStack != null ? macroStack[0].getReparseMacroName() : null;
                            ReparseInfo.ReparseElement[] nextMacroStack = nextReparseInfo != null ? nextReparseInfo.getReparseStack() : null;
                            String string = nextFirstMacroName = nextMacroStack != null ? nextMacroStack[0].getReparseMacroName() : null;
                            if (firstMacroName == null || nextFirstMacroName == null || firstMacroName != null && nextFirstMacroName != null && !firstMacroName.equals(nextFirstMacroName)) {
                                if (firstMacroName != null) {
                                    nextIssue.setMessageForHit(firstMacroName);
                                } else {
                                    nextIssue.setMessageForHit(info);
                                }
                                if (this.pAllowSameLineValue && this.isAllowed(info) && reparseInfo == null) {
                                    if (this.pCheckNextLineEmpty && !this.isEmptyLine(eachFilenameWithIssues, issue.getLine() + 1)) {
                                        nextIssue.setMessageForHit("Next line should be empty or contain only whitespaces!");
                                        resultList.add(new DVTPair((Object)nextIssue, (Object)issue));
                                    }
                                } else {
                                    resultListForce.add(new DVTPair((Object)nextIssue, (Object)issue));
                                }
                            }
                        } else if (!(this.pSkipMacrosValue && (reparseInfo != null || nextReparseInfo != null) || timeControlOperators.contains(info) && nextIssue.getCarry() == 1 || "repeat".equals(info) && "@".equals(nextInfo) || "do".equals(info) && "@".equals(nextInfo) || "begin".equals(nextInfo) || "else".equals(info) && "if".equals(nextInfo) || this.pAllowSameLineValue && (this.isWhile(nextIssue, nextInfo) || this.isJoin(nextInfo)))) {
                            if (this.pAllowSameLineValue && this.isAllowed(info)) {
                                if (this.pCheckNextLineEmpty && !this.isEmptyLine(eachFilenameWithIssues, issue.getLine() + 1)) {
                                    nextIssue.setMessageForHit("Next line should be empty or contain only whitespaces!");
                                    resultList.add(new DVTPair((Object)nextIssue, (Object)issue));
                                }
                            } else {
                                nextIssue.setMessageForHit(info);
                                resultList.add(new DVTPair((Object)nextIssue, (Object)issue));
                            }
                        }
                    }
                }
                ++i;
            }
            resultMap.put(eachFilenameWithIssues, (DVTPair<List<DVTPair<SVTBIssues, SVTBIssues>>, List<DVTPair<SVTBIssues, SVTBIssues>>>)new DVTPair(resultList, resultListForce));
        }
        return resultMap;
    }

    protected VerissimoAutofixAdditionalInfo getVerissimoAutofixAdditionalInfo(SVTBIssues issue, SVTBIssues prev_issue) {
        return new VerissimoAutofixAdditionalInfo(issue, prev_issue);
    }

    private DocumentManager getDocumentManager() {
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
        }
        catch (IllegalStateException illegalStateException) {}
        return docManager;
    }

    private boolean isJoin(String nextInfo) {
        return "join".equals(nextInfo) || "join_none".equals(nextInfo) || "join_any".equals(nextInfo);
    }

    private boolean isWhile(SVTBIssues nextIssue, String nextInfo) {
        return "while".equals(nextInfo) && 1 == nextIssue.getCarry();
    }

    private boolean isAllowed(String info) {
        return this.pAllowedKeywords.contains(info);
    }

    private boolean isSameLine(SVTBIssues issue1, SVTBIssues issue2) {
        return issue1.getLine() == issue2.getLine();
    }

    private boolean insideMacro(SVTBIssues issue1) {
        ReparseInfo reparseInfo1 = issue1.getReparseInfo();
        return reparseInfo1 != null;
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return null;
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return null;
    }
}

