/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_4_2;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.4.2")
@CheckName(value="SVTB.1.4.2")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Define one variable per line")
@CheckDescription(value="Define only one variable per line. Do not define many variables for a type in a single line. This rule allows per variable commenting.\n\nExamples:\nint a, b; // not allowed\nint c; // allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_4_2.class)
public class Check_SVTB_1_4_2
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of enclosing scopes to be skipped: always, case, casex, casez, do, else, for, foreach, if, randcase, repeat and while.", name="skipDeclarationsInScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipDeclarationsInScopes;
    private static final String ALWAYS = "always";
    private static final String CASE = "case";
    private static final String CASEX = "casex";
    private static final String CASEZ = "casez";
    private static final String DO = "do";
    private static final String ELSE = "else";
    private static final String FOR = "for";
    private static final String FOREACH = "foreach";
    private static final String IF = "if";
    private static final String RANDCASE = "randcase";
    private static final String REPEAT = "repeat";
    private static final String WHILE = "while";
    private static final Set<String> allowedKeywords = new HashSet<String>();

    static {
        allowedKeywords.add(ALWAYS);
        allowedKeywords.add(CASE);
        allowedKeywords.add(CASEX);
        allowedKeywords.add(CASEZ);
        allowedKeywords.add(DO);
        allowedKeywords.add(ELSE);
        allowedKeywords.add(FOR);
        allowedKeywords.add(FOREACH);
        allowedKeywords.add(IF);
        allowedKeywords.add(RANDCASE);
        allowedKeywords.add(REPEAT);
        allowedKeywords.add(WHILE);
    }

    public Check_SVTB_1_4_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String scopeToIgnore : this.pSkipDeclarationsInScopes) {
            if (allowedKeywords.contains(scopeToIgnore)) continue;
            this.signalParamError("Value '" + scopeToIgnore + "' is not allowed as parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> allFiles = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath parserPath : allFiles) {
            if (this.fOVMProject.isOVMFile(parserPath.path) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            List<RfField> fields = fileDef.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            fields.addAll(fileDef.getVarsWithPrefix(Integer.MAX_VALUE, "", 2));
            Collections.sort(fields, new Comparator<RfField>(){

                @Override
                public int compare(RfField u1, RfField u2) {
                    return u1.getOffset() - u2.getOffset();
                }
            });
            this.checkMultipleFieldsOnSameLine(fields, parserPath);
            this.checkContainersRecursively(fileDef.getChildren(), parserPath);
        }
    }

    private void checkContainersRecursively(Collection<RfDefElement> children, ParserPath parserPath) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfDefElement element : children) {
            RfNamedElement container;
            if (element.getChildren() == children || element instanceof RfFileDef || (container = element.getNamedElement()) == null || container instanceof RfAssertExpect || container instanceof RfField || container instanceof RfFunctionCall || !this.pSkipDeclarationsInScopes.isEmpty() && this.shouldSkip(container)) continue;
            List<RfField> fields = container.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (container instanceof RfActionBlock) {
                fields.addAll(((RfActionBlock)container).getLocalVarsWithPrefix(Integer.MAX_VALUE, "", 2));
            } else {
                fields.addAll(container.getVarsWithPrefix(Integer.MAX_VALUE, "", 2));
            }
            Collections.sort(fields, new Comparator<RfField>(){

                @Override
                public int compare(RfField u1, RfField u2) {
                    return u1.getOffset() - u2.getOffset();
                }
            });
            this.checkMultipleFieldsOnSameLine(fields, parserPath);
            this.checkContainersRecursively(element.getChildren(), parserPath);
        }
    }

    private void checkMultipleFieldsOnSameLine(List<RfField> fields, ParserPath parserPath) {
        while (!fields.isEmpty()) {
            RfNamedElement scope;
            ParserPath elementParserPath;
            Iterator<RfField> it = fields.iterator();
            if (!it.hasNext()) continue;
            RfField first = it.next();
            it.remove();
            RfFileDef file = first.getFile();
            if (file == null || (elementParserPath = file.getParserPath()) == null || !elementParserPath.equals((Object)parserPath) || first.getDeclaration() == null || first instanceof RfPort || first.isImplicit() || (scope = first.getEnclosingScope()) instanceof RfActionBlock && ((RfActionBlock)scope).isForOrForeach()) continue;
            ArrayList<RfField> fieldsOnTheSameLine = new ArrayList<RfField>();
            while (it.hasNext()) {
                RfDefElement decl2;
                RfDefElement decl1;
                ParserPath anotherElementParserPath;
                RfField anotherElement = it.next();
                RfFileDef anotherFile = anotherElement.getFile();
                if (anotherFile == null || (anotherElementParserPath = anotherFile.getParserPath()) == null || !anotherElementParserPath.equals((Object)elementParserPath) || anotherElement.getDeclaration() == null || anotherElement instanceof RfPort || anotherElement.isImplicit() || (decl1 = first.getDeclaration()).equals(decl2 = anotherElement.getDeclaration())) continue;
                if (decl1.getStartLine() != decl2.getStartLine()) break;
                if ((decl1.getReparseInfo() != null || decl2.getReparseInfo() != null) && (decl1.getReparseInfo() == null || !decl1.getReparseInfo().equals(decl2.getReparseInfo()))) continue;
                it.remove();
                if (fieldsOnTheSameLine.contains(anotherElement)) continue;
                fieldsOnTheSameLine.add(anotherElement);
            }
            if (fieldsOnTheSameLine.isEmpty()) continue;
            if (!fieldsOnTheSameLine.contains(first)) {
                fieldsOnTheSameLine.add(first);
            }
            this.addHit(first, "Two or more variables declared on the same line: " + fieldsOnTheSameLine.stream().map(e -> e.getName()).collect(Collectors.toList()), new VerissimoAutofixAdditionalInfo(fieldsOnTheSameLine));
        }
    }

    private boolean shouldSkip(RfNamedElement container) {
        if (this.pSkipDeclarationsInScopes.isEmpty()) {
            return false;
        }
        if (!(container instanceof RfActionBlock)) {
            return false;
        }
        RfActionBlock actionBlock = (RfActionBlock)container;
        if (this.pSkipDeclarationsInScopes.contains(ALWAYS) && actionBlock.isAlways()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(CASE) && actionBlock.isSimpleCase()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(CASEX) && actionBlock.isCasex()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(CASEZ) && actionBlock.isCasez()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(DO) && actionBlock.isDoWhile()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(ELSE) && actionBlock.isElse()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(FOR) && actionBlock.isFor()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(FOREACH) && actionBlock.isForEach()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(IF) && actionBlock.isIf()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(RANDCASE) && actionBlock.isRandCase()) {
            return true;
        }
        if (this.pSkipDeclarationsInScopes.contains(REPEAT) && actionBlock.isRepeat()) {
            return true;
        }
        return this.pSkipDeclarationsInScopes.contains(WHILE) && actionBlock.isWhile();
    }
}

