/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_4_4;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.4.4")
@CheckName(value="SVTB.1.4.4")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="'begin' should be on the same line with what caused the begin")
@CheckDescription(value="Placing 'begin' on a new line generates unnecessary and confusing whitespace.\nAdditionally, modern editors have code folding that folds the code on the begin. Properly implemented code will be folded on the statement that begins the block.\n\nExamples:\n   if(a) begin // allowed\n      ...\n   if(a)\n      begin // NOT ALLOWED\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_4_4.class)
public class Check_SVTB_1_4_4
extends AbstractSVTBSimpleIssues {
    private static final int BEGIN_STRING_LENGTH = 5;
    @CheckParameter(defaultValue="true", description="Don't check inside macros.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosValue;
    @CheckParameter(defaultValue="false", description="Check begin-end blocks in fork blocks", name="checkForks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckForksValue;

    public Check_SVTB_1_4_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(12);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        String info = (4 & issue.getCarry()) != 0 ? "FORK" : issue.getInfo();
        return "Begin statement not on the same line with what caused the begin" + (info == null ? "" : ": '" + info + "'" + "!");
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(12);
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        if (allIssues == null) {
            return filteredMap;
        }
        HashMap<IRfScopeElement, RfNamedElement> firstMembersInForksMap = new HashMap<IRfScopeElement, RfNamedElement>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entry.getKey();
            if (parserPath == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this) || (issues = entry.getValue()) == null) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                boolean isMacro;
                if (issue == null) continue;
                boolean isFork = (4 & issue.getCarry()) != 0;
                boolean bl = isMacro = issue.getReparseInfo() != null;
                if (this.pSkipMacrosValue && isMacro || !this.pCheckForksValue && isFork || isFork && this.pCheckForksValue && !this.isFirstBeginEndBlockInFork(firstMembersInForksMap, parserPath, issue, isMacro)) continue;
                filteredList.add(issue);
            }
            filteredMap.put(parserPath, filteredList);
        }
        return filteredMap;
    }

    private boolean isFirstBeginEndBlockInFork(Map<IRfScopeElement, RfNamedElement> firstMembersInForksMap, ParserPath parserPath, SVTBIssues issue, boolean isMacro) {
        int issueOffset = isMacro ? issue.getOffset() : issue.getOffset() + 5;
        RfFileDef fileDefUsingParserPath = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
        IRfScopeElement currentElementDef = fileDefUsingParserPath.getScope(issueOffset);
        if (currentElementDef == null) {
            return false;
        }
        if (!(currentElementDef instanceof RfActionBlockDef)) {
            return false;
        }
        RfNamedElement currentElement = ((RfActionBlockDef)currentElementDef).getNamedElement();
        RfNamedElement enclosingFork = currentElement.getEnclosingScope();
        if (!(enclosingFork instanceof RfActionBlock) || !((RfActionBlock)enclosingFork).hasForkJoin()) {
            return false;
        }
        RfNamedElement firstBeginEndBlockInFork = this.getFirstActionBlockInFork(firstMembersInForksMap, enclosingFork);
        return currentElement.equals(firstBeginEndBlockInFork);
    }

    private RfNamedElement getFirstActionBlockInFork(Map<IRfScopeElement, RfNamedElement> firstMembersInForksMap, IRfScopeElement enclosingFork) {
        RfNamedElement firstElementInFork = null;
        int minOffset = Integer.MAX_VALUE;
        if (firstMembersInForksMap.containsKey(enclosingFork)) {
            return firstMembersInForksMap.get(enclosingFork);
        }
        Collection<RfNamedElement> forkMembers = ((RfActionBlock)enclosingFork).getMembers();
        if (forkMembers == null || forkMembers.isEmpty()) {
            return null;
        }
        for (RfNamedElement element : forkMembers) {
            int actionBlockOffset;
            if (!(element instanceof RfActionBlock) || (actionBlockOffset = element.getOffset()) >= minOffset) continue;
            minOffset = actionBlockOffset;
            firstElementInFork = element;
        }
        if (firstElementInFork == null) {
            return null;
        }
        firstMembersInForksMap.put(enclosingFork, firstElementInFork);
        return firstElementInFork;
    }
}

