/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.21")
@CheckID(value="SVTB.1.4.4.1")
@CheckName(value="SVTB.1.4.4.1")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="'end' should be on the same line with what caused the end")
@CheckDescription(value="This rule checks the end keyword is on the same line with the action block that caused it.\n\nExamples:\ndo begin\n  h = a;\nend // not allowed\nwhile (f == g);\n\ndo begin\n  h = a;\nend while (f == g); // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_4_4_1
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String WHILE = "while";
    private static final String BEGIN = "begin";
    private static final String ELSE = "else";
    private static final int ITERATION_LIMIT = 15;
    private static final String IF = "if";
    private static final String DO_WHILE = "do-while";
    private static final String FORK_JOIN = "fork-join";
    @CheckParameter(defaultValue="", description="Comma separated list of action block kinds which are not checked. Possible values: if, do-while, fork-join", name="skipActionBlockKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipActionBlockKind;
    @CheckParameter(defaultValue="false", description="When true, skip checking blocks with end label.", name="skipBlocksWithEndLabel", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipBlocksWithEndLabel;

    @Override
    public void configure() {
        super.configure();
        List<String> acceptedValues = Arrays.asList(IF, DO_WHILE, FORK_JOIN);
        for (String block : this.pSkipActionBlockKind) {
            if (acceptedValues.contains(block)) continue;
            this.signalParamError("'" + block + "' is not an allowed action block!", true);
        }
    }

    public Check_SVTB_1_4_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock block = (RfActionBlock)namedElement;
            if (!block.hasBeginEnd()) {
                return true;
            }
            ParserPath path = block.getFile().getParserPath();
            if (this.checkPreWaivers(path)) {
                return true;
            }
            this.notifyCheckAlive();
            if ((block.isIf() || block.isElsIf()) && !this.pSkipActionBlockKind.contains(IF)) {
                this.addHit(block, path, ELSE);
                return true;
            }
            if (block.isDoWhile() && !this.pSkipActionBlockKind.contains(DO_WHILE)) {
                this.addHitForDoWhile(block, path);
                return true;
            }
            if (!this.pSkipActionBlockKind.contains(FORK_JOIN)) {
                RfNamedElement enclosingScope = block.getEnclosingScope();
                while (enclosingScope instanceof RfActionBlock) {
                    if (((RfActionBlock)enclosingScope).isForkJoin()) {
                        this.addHit(block, path, BEGIN);
                        return true;
                    }
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
            }
            return true;
        });
    }

    private void addHit(RfActionBlock block, ParserPath path, String value) {
        String hitString;
        RfDefElement blockDeclaration = block.getDeclaration();
        if (blockDeclaration == null) {
            return;
        }
        boolean hasEndLabel = blockDeclaration.hasEndLabel();
        int offset = block.getEndOffset() - 1;
        LiteralToken token = this.getWSParser().getTokenContainingOffset(offset, path);
        if (token == null) {
            return;
        }
        LiteralToken nextToken = token;
        if (hasEndLabel) {
            if (this.pSkipBlocksWithEndLabel) {
                return;
            }
            if (token.getStringToken().contains(":")) {
                if (token.getStringToken().startsWith(":")) {
                    token = this.getWSParser().getPrevToken(token, path);
                }
            } else {
                token = this.getWSParser().getPrevToken(token, path);
                if (token == null) {
                    return;
                }
                if (token.getStringToken().equals(":")) {
                    token = this.getWSParser().getPrevToken(token, path);
                }
            }
            if (token == null) {
                return;
            }
            nextToken = this.getWSParser().getNextToken(nextToken, path);
            while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                nextToken = this.getWSParser().getNextToken(nextToken, path);
            }
            if (nextToken == null) {
                return;
            }
        } else {
            nextToken = this.getWSParser().getNextToken(nextToken, path);
            while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                nextToken = this.getWSParser().getNextToken(nextToken, path);
            }
            if (nextToken == null) {
                return;
            }
        }
        String string = hitString = value.equals(ELSE) ? "End statement not on the same line with what caused the end: else keyword!" : "End statement not on the same line with what caused the end: begin keyword!";
        if (token.getLineNumber() != nextToken.getLineNumber() && nextToken.getStringToken().contains(value)) {
            this.addHit(path, token.getLineNumber(), hitString, null);
        }
    }

    private void addHitForDoWhile(RfActionBlock block, ParserPath path) {
        LiteralToken endToken;
        LiteralToken whileToken;
        block15: {
            block13: {
                block14: {
                    RfDefElement blockDeclaration = block.getDeclaration();
                    if (blockDeclaration == null) {
                        return;
                    }
                    boolean hasEndLabel = blockDeclaration.hasEndLabel();
                    if (this.pSkipBlocksWithEndLabel && hasEndLabel) {
                        return;
                    }
                    int offset = block.getEndOffset() - 1;
                    LiteralToken token = this.getWSParser().getTokenContainingOffset(offset, path);
                    if (token == null) {
                        return;
                    }
                    whileToken = null;
                    int i = 0;
                    while (i < 15 && token != null) {
                        if (token.getStringToken().startsWith(WHILE) && token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                            whileToken = token;
                            break;
                        }
                        token = this.getWSParser().getPrevToken(token, path);
                        ++i;
                    }
                    if (whileToken == null) {
                        return;
                    }
                    endToken = whileToken;
                    if (!hasEndLabel) break block13;
                    endToken = this.getWSParser().getPrevToken(endToken, path);
                    while (endToken != null && endToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                        endToken = this.getWSParser().getPrevToken(endToken, path);
                    }
                    if (endToken == null) {
                        return;
                    }
                    if (!endToken.getStringToken().contains(":")) break block14;
                    if (endToken.getStringToken().startsWith(":")) {
                        endToken = this.getWSParser().getPrevToken(endToken, path);
                    }
                    break block15;
                }
                endToken = this.getWSParser().getPrevToken(endToken, path);
                if (endToken == null) {
                    return;
                }
                if (!endToken.getStringToken().equals(":")) break block15;
                endToken = this.getWSParser().getPrevToken(endToken, path);
                break block15;
            }
            endToken = this.getWSParser().getPrevToken(endToken, path);
            while (endToken != null && endToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                endToken = this.getWSParser().getPrevToken(endToken, path);
            }
        }
        if (endToken == null) {
            return;
        }
        if (endToken != null && whileToken != null && endToken.getLineNumber() != whileToken.getLineNumber()) {
            this.addHit(path, endToken.getLineNumber(), "End statement not on the same line with what caused the end: while keyword!", null);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

