/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_4_5;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="16.1.37")
@CheckID(value="SVTB.1.4.5")
@CheckName(value="SVTB.1.4.5")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.FILE, RuleLabel.BEGIN_END})
@CheckTitle(value="'begin' must be placed on the same line or the next line consistently in the same file")
@CheckDescription(value="A file must have the same 'begin' placement for every block. This can be either on the same line or the next line with what caused the 'begin'.\n\nExamples:\nif (1==1) begin\nend\n\nfor (int i=0; i<1; i++)\nbegin // not allowed\nend\n\nfor (int i=0; i<1; i++) begin // allowed\nend\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_4_5.class)
public class Check_SVTB_1_4_5
extends AbstractFormattingDisabledCheck {
    @CheckParameter(defaultValue="true", description="Don't check inside macros.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosValue;
    @CheckParameter(defaultValue="false", description="When true, checks if the 'begin' keyword is placed consistently over the block types that are of the same kind in the same file.", name="checkBlockConsistency", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckBlockConsistency;

    public Check_SVTB_1_4_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(12);
        aRfProject.lintTrackP2LInfo(132);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> newLineIssuesMap = this.fOVMProject.getSVTBIssuesWithKind(12);
        if (newLineIssuesMap == null || newLineIssuesMap.isEmpty()) {
            return;
        }
        Map<ParserPath, List<SVTBIssues>> sameLineIssuesMap = this.fOVMProject.getSVTBIssuesWithKind(132);
        if (sameLineIssuesMap == null || sameLineIssuesMap.isEmpty()) {
            return;
        }
        this.signalInconsistentBlocks(newLineIssuesMap, sameLineIssuesMap);
    }

    private void signalInconsistentBlocks(Map<ParserPath, List<SVTBIssues>> newLineIssues, Map<ParserPath, List<SVTBIssues>> sameLineIssues) {
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : newLineIssues.entrySet()) {
            Issues validSameLineIssues;
            ParserPath path = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this) || !sameLineIssues.containsKey(path)) continue;
            this.notifyCheckAlive();
            Issues validNewLineIssues = this.getValidIssues(entry.getValue());
            if (validNewLineIssues.isEmpty() || (validSameLineIssues = this.getValidIssues(sameLineIssues.get(path))).isEmpty()) continue;
            this.reportIssues(path, validNewLineIssues, validSameLineIssues);
        }
    }

    private void reportIssues(ParserPath path, Issues validNewLineIssues, Issues validSameLineIssues) {
        List<SVTBIssues> newLineIssues = null;
        List<SVTBIssues> sameLineIssues = null;
        if (!this.pCheckBlockConsistency) {
            newLineIssues = validNewLineIssues.getAllIssues();
            sameLineIssues = validSameLineIssues.getAllIssues();
            if (newLineIssues.size() <= sameLineIssues.size()) {
                this.reportIssues(path, newLineIssues);
            } else {
                this.reportIssues(path, sameLineIssues);
            }
        } else {
            Map<String, List<SVTBIssues>> sameLineIssuesByCategory = validSameLineIssues.getIssuesByCategory();
            for (Map.Entry<String, List<SVTBIssues>> entry : sameLineIssuesByCategory.entrySet()) {
                String key = entry.getKey();
                newLineIssues = entry.getValue();
                sameLineIssues = validNewLineIssues.getIssuePerBlockType(key);
                if (sameLineIssues == null) continue;
                if (newLineIssues.size() <= sameLineIssues.size()) {
                    this.reportIssues(path, newLineIssues);
                    continue;
                }
                if (newLineIssues.size() <= sameLineIssues.size()) continue;
                this.reportIssues(path, sameLineIssues);
            }
        }
    }

    private Issues getValidIssues(List<SVTBIssues> issues) {
        Issues validIssues = new Issues();
        if (issues == null || issues.isEmpty()) {
            return validIssues;
        }
        for (SVTBIssues issue : issues) {
            if (issue == null || (4 & issue.getCarry()) != 0 || this.pSkipMacrosValue && issue.getReparseInfo() != null) continue;
            if (!this.pCheckBlockConsistency) {
                validIssues.addIssue(issue);
                continue;
            }
            String info = issue.getInfo();
            if (info == null) continue;
            validIssues.addIssue(info, issue);
        }
        return validIssues;
    }

    private void reportIssues(ParserPath path, List<SVTBIssues> issues) {
        for (SVTBIssues issue : issues) {
            String message = null;
            String info = issue.getInfo();
            boolean mustBeOnSameLine = false;
            switch (issue.getKind()) {
                case 12: {
                    message = "'begin' statement is not on the same line with the statement " + (info == null ? "" : "'" + info.toLowerCase() + "'" + " that caused it, most 'begin' statements " + (this.pCheckBlockConsistency ? " caused by " + "'" + info.toLowerCase() + "'" + " statements " : "") + "are on the same line in this file!");
                    mustBeOnSameLine = true;
                    break;
                }
                case 132: {
                    message = "'begin' statement is on the same line with the statement " + (info == null ? "" : "'" + info.toLowerCase() + "'" + " that caused it, most 'begin' statements " + (this.pCheckBlockConsistency ? " caused by " + "'" + info.toLowerCase() + "'" + " statements " : "") + "are not on the same line in this file!");
                }
            }
            this.addHit(path, issue.getLine(), message, issue.getReparseInfo(), new VerissimoAutofixAdditionalInfo(issue, mustBeOnSameLine));
        }
    }

    static class Issues {
        List<SVTBIssues> allIssues = null;
        Map<String, List<SVTBIssues>> issuesByCategory = null;

        Issues() {
        }

        public void addIssue(SVTBIssues issue) {
            if (this.allIssues == null) {
                this.allIssues = new ArrayList<SVTBIssues>();
            }
            this.allIssues.add(issue);
        }

        public void addIssue(String kind, SVTBIssues issue) {
            if (this.issuesByCategory == null) {
                this.issuesByCategory = new HashMap<String, List<SVTBIssues>>();
            }
            this.issuesByCategory.putIfAbsent(kind, new ArrayList());
            this.issuesByCategory.get(kind).add(issue);
        }

        public boolean isEmpty() {
            return this.allIssues == null && this.issuesByCategory == null;
        }

        public List<SVTBIssues> getAllIssues() {
            return this.allIssues;
        }

        public Map<String, List<SVTBIssues>> getIssuesByCategory() {
            return this.issuesByCategory;
        }

        public boolean hasBlockType(String type) {
            return this.issuesByCategory != null && this.issuesByCategory.containsKey(type);
        }

        public List<SVTBIssues> getIssuePerBlockType(String type) {
            if (!this.hasBlockType(type)) {
                return null;
            }
            return this.issuesByCategory.get(type);
        }
    }
}

