/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_5;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSingleStatementCheck;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.5")
@CheckName(value="SVTB.1.5")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="Use begin / end block for 'single statements'")
@CheckDescription(value="A 'single statement' may cause confusion, especially if the indentation is wrong.\nAlso, subsequent statements added later require a begin / end block and a less experienced coder may not know this.\n\nExamples:\n   while (true)\n      statement; // NOT ALLOWED - statement is inside the while loop\n   next_statement; // next_statement is outside the while loop! Confusing without proper indent!\n\n   if (cond1)\n      statement; // NOT ALLOWED\n      if (cond2)\n         statement; // NOT ALLOWED\n   else // !!! Applies to the cond2 if statement, although it looks like else cond1! Confusing with improper indent!\n      statement; // NOT ALLOWED\n\n   if (foo) bar = 1; // allowed IFF allowSameLine\n\n   if (foo)\n        bar = 1; // NOT ALLOWED, even if allowSameLine\n\n   if (x==y) return; // allowed IFF allowSameLine\n\n   if (a==b)\n      return 0; // NOT ALLOWED\n   else\n      return 1; // NOT ALLOWED\n\n   fork: my_fork\n      statement1; // allowed IFF allowForkedSingleStatements\n      statement1; // allowed IFF allowForkedSingleStatements\n   join: my_fork\n\n   if(foo)\n      `xvm_info(...) // allowed IFF skipXVMMacros\n\n   if(foo)\n      ...\n   else if(boo) // allowed exception\n\n   case(a)\n      0:\n           x = 4; // NOT ALLOWED even if allowCaseItemSingleStatements\n      1: x = 5; // allowed IFF allowCaseItemSingleStatements\n   endcase\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_1_5.class)
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
public class Check_SVTB_1_5
extends AbstractSingleStatementCheck {
    @CheckParameter(defaultValue="false", description="Allow single statements placed on the same line with the enclosing construct.", name="allowSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSameLineValue;
    @CheckParameter(defaultValue="false", description="Allow single statements in fork/join.", name="allowForkedSingleStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowForkedSingleStatementsValue;
    @CheckParameter(defaultValue="false", description="Allow single case item statements in case statement.", name="allowCaseItemSingleStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowCaseItemSingleStatementsValue;
    @CheckParameter(defaultValue="true", description="If true, single statements of macros are allowed.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosValue;
    @CheckParameter(defaultValue="true", description="If true, single statements of XVM macros are allowed.", name="skipXVMMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipXVMMacrosValue;

    public Check_SVTB_1_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(38);
        aRfProject.lintTrackP2LInfo(114);
        aRfProject.lintTrackP2LInfo(129);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue, ParserPath parserPath) {
        String messageForHit = issue.getMessageForHit();
        if (issue != null && messageForHit != null && messageForHit.equals("Next line should be empty or contain only whitespaces!") && this.pAllowSameLineValue && this.pCheckNextLineEmpty) {
            return "Next line should be empty or contain only whitespaces!";
        }
        IDocument document = this.docManager.getDocument(parserPath, this.getIProject());
        if (issue != null && issue.getInfo() != null) {
            ReparseInfo reparseInfo;
            if ((2 & issue.getCarry()) != 0 && (reparseInfo = issue.getReparseInfo()) != null && reparseInfo.getReparseStackSize() > 0) {
                ReparseInfo.ReparseElement[] reparseStack = reparseInfo.getReparseStack();
                ReparseInfo.ReparseElement reparseElement = reparseStack[0];
                return "Statement '`" + reparseElement.getReparseMacroName() + "...' must be enclosed in a begin/end block at line offset " + this.getOffsetOnLine(document, issue) + "!";
            }
            return "Statement '" + issue.getInfo() + "...' must be enclosed in a begin/end block at line offset " + this.getOffsetOnLine(document, issue) + "!";
        }
        return "Statement must be enclosed in a begin/end block!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(38);
        Map<ParserPath, List<SVTBIssues>> multilineIssues = this.fOVMProject.getSVTBIssuesWithKind(114);
        Map<ParserPath, List<SVTBIssues>> emptyStatements = this.fOVMProject.getSVTBIssuesWithKind(129);
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        if (allIssues == null) {
            return filteredMap;
        }
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entry.getKey();
            if (parserPath == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this) || (issues = entry.getValue()) == null) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            Set<Object> linesWithAllowedKeywords = new HashSet();
            List<SVTBIssues> emptyStatementsInFile = emptyStatements.get(parserPath);
            List<SVTBIssues> multiline = multilineIssues.get(parserPath);
            if (this.pAllowSameLineValue && multiline != null) {
                linesWithAllowedKeywords = this.getLinesWithAllowedKeywords(multiline);
            }
            block1: for (SVTBIssues issue : issues) {
                int line = issue.getLine();
                if (this.pAllowSameLineValue && (1 & issue.getCarry()) != 0 && (this.pAllowedKeywords.isEmpty() || linesWithAllowedKeywords.contains(line))) {
                    if (!this.pCheckNextLineEmpty || this.isEmptyLine(parserPath, issue.getLine() + 1)) continue;
                    filteredList.add(issue);
                    issue.setMessageForHit("Next line should be empty or contain only whitespaces!");
                    continue;
                }
                if (this.pAllowForkedSingleStatementsValue && (4 & issue.getCarry()) != 0 || this.pAllowCaseItemSingleStatementsValue && (9 & issue.getCarry()) == 9) continue;
                if (issue.getReparseInfo() != null) {
                    String prefix = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
                    ReparseInfo.ReparseElement[] reparseStack = issue.getReparseInfo().getReparseStack();
                    String macroName = issue.getReparseInfo().getLastReparseMacroName();
                    if (emptyStatementsInFile != null) {
                        for (SVTBIssues emptyStatement : emptyStatementsInFile) {
                            if (emptyStatement.getLine() == issue.getLine() && emptyStatement.getReparseInfo() != null) continue block1;
                        }
                    }
                    if (reparseStack.length != 0) {
                        macroName = reparseStack[0].getReparseMacroName();
                    }
                    if (!macroName.startsWith(prefix)) {
                        if (this.pSkipMacrosValue) continue;
                        filteredList.add(issue);
                    }
                    if (this.pSkipXVMMacrosValue || (2 & issue.getCarry()) == 0) continue;
                    filteredList.add(issue);
                    continue;
                }
                if (this.pAllowSameLineValue && linesWithAllowedKeywords.contains(line)) continue;
                filteredList.add(issue);
            }
            filteredMap.put(parserPath, filteredList);
        }
        return filteredMap;
    }

    private Set<Integer> getLinesWithAllowedKeywords(List<SVTBIssues> multiline) {
        HashSet<Integer> linesWithAllowedKeywords = new HashSet<Integer>();
        for (SVTBIssues issue : multiline) {
            int line = issue.getLine();
            String info = issue.getInfo();
            if (info == null || !this.pAllowedKeywords.contains(info)) continue;
            linesWithAllowedKeywords.add(line);
        }
        return linesWithAllowedKeywords;
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return null;
    }

    @Override
    protected boolean isForceFailure(ReparseInfo reparseInfo) {
        return true;
    }
}

