/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_5_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.1.5.1")
@CheckName(value="SVTB.1.5.1")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONSTRAINT})
@CheckTitle(value="Use { } block for single line constraints")
@CheckDescription(value="Similar with rule 1.5, single constraints within if, foreach or implication (->) should use { } block.\n\nImplementation Notes:\nThe linter checks that constraint set after implication (->), if and foreach is placed between { and }.\n\nA frequent hard to spot mistake that makes the rule fail is to use semicolon after the brackets used for a foreach block.\nThe result is syntactically correct but it has a different meaning from the usual intended usage.\nUsing the semicolon after the curly brackets transforms the whole expression into a concatenation.\n\n  constraint c {        \n    foreach(a[i])       \n    {                   \n      a[i] == VALUE; // <- Semicolon correctly placed \n    }; // <- Semicolon wrongly placed \n  }\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_5_1.class)
public class Check_SVTB_1_5_1
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="false", description="Skip if on one physical line. When true:\n\t\tforeach(a[i]) { a[i] == VALUE;} // OK\n\t\tforeach(a[i]) { a[i] == VALUE }; // Also OK!!!", name="allowSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSameLineValue;

    public Check_SVTB_1_5_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(108);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue, ParserPath parserPath) {
        String info = issue.getInfo();
        IDocument document = this.docManager.getDocument(parserPath, this.getIProject());
        return "Single line constraint without {} at line offset " + this.getOffsetOnLine(document, issue) + (info == null ? "" : " - " + info + "!");
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(108);
        if (!this.pAllowSameLineValue) {
            return allIssues;
        }
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        if (allIssues == null) {
            return filteredMap;
        }
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entry.getKey();
            if (parserPath == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this) || (issues = entry.getValue()) == null) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                if (this.pAllowSameLineValue && issue.getCarry() == 1) continue;
                filteredList.add(issue);
            }
            filteredMap.put(parserPath, filteredList);
        }
        return filteredMap;
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return null;
    }
}

