/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_5_2;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="19.1.44")
@CheckID(value="SVTB.1.5.2")
@CheckName(value="SVTB.1.5.2")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONDITIONAL})
@CheckTitle(value="Single statement following an 'if' should be on the same line or immediately on the next line with increased indentation")
@CheckDescription(value="This rule checks that single statements are on the same line or immediately on the next line of the enclosing 'if' statement.\nWhen the single statement is on the next line, then it should have increased indentation relative to the indentation of the 'if' statement.\n\nExamples:\n   if (a == b)\nreturn 1; // not allowed\n\nif (a == b + 1)\n   return 2; // allowed\n\nif (a == b + 2)\n\n   return 3; // not allowed\n\nif (a == b + 3) begin\n\n   return 4; // allowed\nend\n\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_5_2.class)
public class Check_SVTB_1_5_2
extends AbstractSVTBSimpleIssues {
    private static final String ERROR_MESSAGE_FORMAT = "Single statement {0}should have an increased indentation relative to the indentation of the {1} statement!";
    private ContentReader contentReader = new ContentReader();
    private Map<SVTBIssues, RfNamedElement> ifBlocksByIssue = new HashMap<SVTBIssues, RfNamedElement>();
    @CheckParameter(defaultValue="false", description="When true, allows lines with comments between 'if' and the following single statement.", name="allowLinesWithComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowLinesWithComments;

    public Check_SVTB_1_5_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(38);
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        this.contentReader.clear();
        this.ifBlocksByIssue.clear();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(38);
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        if (allIssues == null) {
            return filteredMap;
        }
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        HashMap<ParserPath, ArrayList<RfActionBlock>> actionBlocksByParserPath = new HashMap<ParserPath, ArrayList<RfActionBlock>>();
        for (RfActionBlock rfActionBlock : allActionBlocks) {
            RfDefElement declaration;
            if (!rfActionBlock.isIf() && !rfActionBlock.isElsIf() || rfActionBlock.hasBeginEnd() || this.shouldSkip(rfActionBlock) || (declaration = rfActionBlock.getDeclaration()) == null) continue;
            ParserPath parserPath = declaration.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            ArrayList<RfActionBlock> blocks = (ArrayList<RfActionBlock>)actionBlocksByParserPath.get(parserPath);
            if (blocks == null) {
                blocks = new ArrayList<RfActionBlock>();
                blocks.add(rfActionBlock);
                actionBlocksByParserPath.put(parserPath, blocks);
                continue;
            }
            blocks.add(rfActionBlock);
        }
        for (Map.Entry entry : allIssues.entrySet()) {
            List actionBlocks;
            List issues;
            RfFileDef filedef;
            ParserPath parserPath = (ParserPath)entry.getKey();
            if (parserPath == null || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath)) == null || (issues = (List)entry.getValue()) == null || (actionBlocks = (List)actionBlocksByParserPath.get(parserPath)) == null || actionBlocks.isEmpty()) continue;
            this.notifyCheckAlive();
            final HashMap<Integer, LinePair> ifLinesMap = new HashMap<Integer, LinePair>();
            int blockIndex = 0;
            int blocksNr = actionBlocks.size();
            Collections.sort(actionBlocks, (a, b) -> a.getOffset() < b.getOffset() ? -1 : (a.getOffset() == b.getOffset() ? 0 : 1));
            Collections.sort(issues, (a, b) -> a.getOffset() < b.getOffset() ? -1 : (a.getOffset() == b.getOffset() ? 0 : 1));
            for (final SVTBIssues issue : issues) {
                if (blockIndex == blocksNr) break;
                int issueOffset = issue.getOffset();
                while (blockIndex + 1 < blocksNr && ((RfNamedElement)actionBlocks.get(blockIndex + 1)).getStartOffset() < issueOffset) {
                    ++blockIndex;
                }
                if (((RfNamedElement)actionBlocks.get(blockIndex)).getEndOffset() < issueOffset || ((RfNamedElement)actionBlocks.get(blockIndex)).getStartOffset() > issueOffset) continue;
                final RfNamedElement actionBlock = (RfNamedElement)actionBlocks.get(blockIndex);
                ++blockIndex;
                final boolean[] foundIf = new boolean[1];
                actionBlock.visitHidObject(null, new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator hidObject) {
                        if (hidObject.isIfCondition()) {
                            HidOperatorOccurrence occurrence = hidObject.getOccurrence();
                            if (occurrence == null) {
                                return true;
                            }
                            foundIf[0] = true;
                            if (issue.getLine() != occurrence.getLine()) {
                                int lineWhereIfCloses = actionBlock.getDeclaration().getStartLine();
                                LinePair p = new LinePair(issue.getLine(), lineWhereIfCloses, issue.getOffset());
                                ifLinesMap.put(occurrence.getLine(), p);
                                Check_SVTB_1_5_2.this.ifBlocksByIssue.put(issue, actionBlock);
                            }
                            return false;
                        }
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            List<Integer> lineNumbersOfIssuesToKeep = this.getLinesOfIssuesToReport(parserPath, ifLinesMap);
            for (SVTBIssues issue : issues) {
                if (!lineNumbersOfIssuesToKeep.contains(issue.getLine())) continue;
                filteredList.add(issue);
            }
            filteredMap.put(parserPath, filteredList);
        }
        return filteredMap;
    }

    private boolean shouldSkip(RfActionBlock actionBlock) {
        Collection<RfNamedElement> members = actionBlock.getMembers();
        if (members == null || members.isEmpty()) {
            return false;
        }
        boolean containsIfBlock = members.stream().filter(member -> {
            if (!(member instanceof RfActionBlock)) {
                return false;
            }
            RfActionBlock block = (RfActionBlock)member;
            if (!block.isIf() && !block.isElsIf()) {
                return false;
            }
            return !block.hasBeginEnd();
        }).findAny().isPresent();
        return !containsIfBlock;
    }

    /*
     * Unable to fully structure code
     */
    private List<Integer> getLinesOfIssuesToReport(ParserPath parserPath, Map<Integer, LinePair> ifLinesMap) {
        result = new ArrayList<Integer>();
        for (Map.Entry<Integer, LinePair> entry : ifLinesMap.entrySet()) {
            block4: {
                ifStartLine = entry.getKey();
                linePair = entry.getValue();
                issueLine = linePair.getIssueLine();
                if (issueLine.equals(ifEndLine = Integer.valueOf(linePair.getIfEndsLine()))) continue;
                if (issueLine == ifEndLine + 1) break block4;
                if (!this.pAllowLinesWithComments) {
                    result.add(issueLine);
                    continue;
                }
                currentToken = this.getWSParser().getToken(linePair.getIssueOffset(), parserPath);
                prevToken = this.getWSParser().getPrevToken(currentToken, parserPath);
                if (currentToken == null || prevToken == null) continue;
                if (prevToken.getLineNumber() != ifEndLine.intValue()) ** GOTO lbl24
                result.add(issueLine);
                continue;
lbl-1000:
                // 1 sources

                {
                    currentToken = prevToken;
                    prevToken = this.getWSParser().getPrevToken(currentToken, parserPath);
                    if (prevToken == null || prevToken.getLineNumber() == ifEndLine.intValue() || currentToken.getLineNumber() <= prevToken.getLineNumber() + 1 || !currentToken.getStringToken().startsWith("//") && (!prevToken.getStringToken().endsWith("*/") || !currentToken.getStringToken().startsWith("/*"))) continue;
                    result.add(issueLine);
lbl24:
                    // 3 sources

                    ** while (prevToken != null && (prevToken.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || prevToken.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT))
                }
lbl25:
                // 1 sources

                if (prevToken != null && prevToken.getLineNumber() != ifEndLine.intValue()) {
                    result.add(issueLine);
                    continue;
                }
            }
            if (!(shouldHit = this.isNotProperlyIndented(parserPath, ifStartLine, issueLine))) continue;
            result.add(issueLine);
        }
        return result;
    }

    private boolean isNotProperlyIndented(ParserPath parserPath, int ifStartLine, int issueLine) {
        int nrOfTabsIfLine = 0;
        int nrOfTabsIssueLine = 0;
        int nrOfSpacesIfLine = 0;
        int nrOfSpacesIssueLine = 0;
        List<LiteralToken> ifTokens = this.getWSParser().getTokensOnLine(parserPath, ifStartLine);
        List<LiteralToken> issueTokens = this.getWSParser().getTokensOnLine(parserPath, issueLine);
        if (ifTokens.isEmpty() || issueTokens.isEmpty()) {
            return false;
        }
        for (LiteralToken token : ifTokens) {
            if (token.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) {
                nrOfTabsIfLine += token.getNoTabsBefore();
                continue;
            }
            nrOfSpacesIfLine = token.getOffsetLine() - (nrOfTabsIfLine += token.getNoTabsBefore());
            break;
        }
        for (LiteralToken token : issueTokens) {
            if (token.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) {
                nrOfTabsIssueLine += token.getNoTabsBefore();
                continue;
            }
            nrOfSpacesIssueLine = token.getOffsetLine() - (nrOfTabsIssueLine += token.getNoTabsBefore());
            break;
        }
        if (nrOfTabsIfLine > nrOfTabsIssueLine) {
            return true;
        }
        if (nrOfTabsIfLine == nrOfTabsIssueLine) {
            return nrOfSpacesIfLine >= nrOfSpacesIssueLine;
        }
        return nrOfSpacesIfLine > nrOfSpacesIssueLine;
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        String message;
        RfNamedElement element = this.ifBlocksByIssue.get(issue);
        if (!(element instanceof RfActionBlock)) {
            return MessageFormat.format(ERROR_MESSAGE_FORMAT, "", "enclosing if statement");
        }
        RfActionBlock ifBlock = (RfActionBlock)element;
        if (issue.getLine() != ifBlock.getDeclaration().getStartLine() + 1) {
            int properLine = ifBlock.getDeclaration().getStartLine() + 1;
            message = MessageFormat.format(ERROR_MESSAGE_FORMAT, "should be on line " + properLine + " and ", "'if(" + ifBlock.getExpression() + ")'");
        } else {
            message = MessageFormat.format(ERROR_MESSAGE_FORMAT, "", "'if(" + ifBlock.getExpression() + ")'");
        }
        return message;
    }

    @Override
    protected VerissimoAutofixAdditionalInfo getVerissimoAutofixAdditionalInfo(SVTBIssues issue) {
        return new VerissimoAutofixAdditionalInfo(issue, this.ifBlocksByIssue.get(issue));
    }

    @Override
    public void clean() {
        super.clean();
        if (this.contentReader != null) {
            this.contentReader.clear();
        }
    }

    class ContentReader {
        private Map<ParserPath, List<String>> readFiles = new HashMap<ParserPath, List<String>>();

        String getLine(ParserPath parserPath, Integer line) {
            List<String> fileContent;
            if (!this.readFiles.containsKey(parserPath)) {
                this.readFile(parserPath);
            }
            if ((fileContent = this.readFiles.get(parserPath)).size() <= line - 1) {
                return null;
            }
            return fileContent.get(line - 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readFile(ParserPath parserPath) {
            BufferedReader reader = null;
            String line = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(parserPath.path));
                    if (!this.readFiles.containsKey(parserPath)) {
                        this.readFiles.put(parserPath, new ArrayList());
                    }
                    while ((line = reader.readLine()) != null) {
                        this.readFiles.get(parserPath).add(line);
                    }
                    return;
                }
                catch (FileNotFoundException e) {
                    Check_SVTB_1_5_2.this.fOVMProject.notifyCheckException(Check_SVTB_1_5_2.this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        Check_SVTB_1_5_2.this.fOVMProject.notifyCheckException(Check_SVTB_1_5_2.this, e2);
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                    return;
                }
                catch (IOException e) {
                    Check_SVTB_1_5_2.this.fOVMProject.notifyCheckException(Check_SVTB_1_5_2.this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (reader == null) return;
                    try {
                        reader.close();
                        return;
                    }
                    catch (IOException e3) {
                        Check_SVTB_1_5_2.this.fOVMProject.notifyCheckException(Check_SVTB_1_5_2.this, e3);
                        DVTLogger.INSTANCE.logError((Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Check_SVTB_1_5_2.this.fOVMProject.notifyCheckException(Check_SVTB_1_5_2.this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }

        private void clear() {
            this.readFiles.clear();
        }
    }

    static class LinePair {
        private int issueLine;
        private int ifEndsLine;
        private int issueOffset;

        public LinePair(int issueLine, int ifEndsLine, int issueOffset) {
            this.issueLine = issueLine;
            this.ifEndsLine = ifEndsLine;
            this.issueOffset = issueOffset;
        }

        public int getIssueLine() {
            return this.issueLine;
        }

        public int getIfEndsLine() {
            return this.ifEndsLine;
        }

        public int getIssueOffset() {
            return this.issueOffset;
        }
    }
}

