/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_5_3;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.24")
@CheckID(value="SVTB.1.5.3")
@CheckName(value="SVTB.1.5.3")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.CONSTRAINT})
@CheckTitle(value="{ and } must be on the same line with their associated element")
@CheckDescription(value="This rule checks that { and } are on the same line with their associated element inside a constraint.\n\nExamples:\nconstraint my_const { // allowed\n\tif (a == b) { // allowed\n  \tc = 2;\n\t} else {  // allowed\n\t\tc = 4;\n\t}  // allowed\n\n\tif (e == f)\n\t{ // not allowed\n  \tc = 2;\n\t} // not allowed\n\telse { // allowed\n\t\tc = 4;\n\t}  // allowed\n\n} // allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_5_3.class)
public class Check_SVTB_1_5_3
extends AbstractFormattingDisabledCheck {
    Map<ParserPath, Set<LiteralToken>> concatOrAssignTokens;
    Map<ParserPath, List<RfConstraint>> constraintsMap;

    public Check_SVTB_1_5_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.concatOrAssignTokens = new HashMap<ParserPath, Set<LiteralToken>>();
        this.constraintsMap = new HashMap<ParserPath, List<RfConstraint>>();
        LocalHidVisitor localVisitor = new LocalHidVisitor();
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (namedElement.isPredefined()) {
                return true;
            }
            if (!(namedElement instanceof RfConstraint)) {
                return true;
            }
            if (namedElement.getFile() == null) {
                return true;
            }
            this.notifyCheckAlive();
            ParserPath parserPath = namedElement.getFile().getParserPath();
            if (this.checkPreWaivers(parserPath)) {
                return true;
            }
            if (this.constraintsMap.get(parserPath) == null) {
                this.constraintsMap.put(parserPath, new ArrayList());
            }
            this.constraintsMap.get(parserPath).add((RfConstraint)namedElement);
            localVisitor.setParserPath(parserPath);
            namedElement.visitHidObject(this.fOVMProject.getRfProject(), localVisitor);
            return true;
        });
        this.parseTokens();
        this.concatOrAssignTokens.clear();
        this.constraintsMap.clear();
    }

    private void parseTokens() {
        for (Map.Entry<ParserPath, List<RfConstraint>> entry : this.constraintsMap.entrySet()) {
            ParserPath path = entry.getKey();
            List<RfConstraint> constraints = entry.getValue();
            if (constraints == null || constraints.isEmpty()) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokensMap = this.getWSParser().getTokens(path);
            if (tokensMap == null) continue;
            Set concatOrAssignTokensSet = this.concatOrAssignTokens.get(path) == null ? Collections.emptySet() : this.concatOrAssignTokens.get(path);
            for (RfConstraint constraint : constraints) {
                LiteralToken startToken = this.getWSParser().getTokenContainingOffset(constraint.getStartOffset(), path);
                LiteralToken endToken = this.getWSParser().getTokenContainingOffset(constraint.getEndOffset(), path);
                if (startToken == null || endToken == null) continue;
                LiteralToken previousTokenWithCode = null;
                LiteralToken token = startToken;
                while (this.isEndOfConstraint(token, endToken)) {
                    if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                        LiteralToken nextToken;
                        if (token.getStringToken().charAt(0) == '{' && token.isFirstTokenOnLine() && !concatOrAssignTokensSet.contains(token)) {
                            this.addHit(path, token.getLineNumber(), "The '{' is not on the same line with what caused it!", null, new VerissimoAutofixAdditionalInfo(token, previousTokenWithCode));
                        } else if (token.getStringToken().charAt(token.getLength() - 1) == '}' && (nextToken = tokensMap.get(token.getOffsetFileNextToken())) != null && token.getLineNumber() != nextToken.getLineNumber() && nextToken.getStringToken().startsWith("else") && !concatOrAssignTokensSet.contains(token)) {
                            this.addHit(path, token.getLineNumber(), "The '}' is not on the same line with what caused it!", null, new VerissimoAutofixAdditionalInfo(nextToken, token));
                        }
                    }
                    previousTokenWithCode = this.getPreviousTokenWithCode(previousTokenWithCode, token);
                    token = tokensMap.get(token.getOffsetFileNextToken());
                }
            }
        }
    }

    private LiteralToken getPreviousTokenWithCode(LiteralToken previousTokenWithCode, LiteralToken token) {
        if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
            return token;
        }
        return previousTokenWithCode;
    }

    private boolean isEndOfConstraint(LiteralToken token, LiteralToken endToken) {
        return token != null && !token.equals(endToken) && token.getOffsetFileNextToken() != -1;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (!operator.isConcatOrAssignPatternOperator()) {
                return true;
            }
            LiteralToken token = Check_SVTB_1_5_3.this.getWSParser().getTokenContainingOffset(operator.getOpenBoundary(), this.parserPath);
            if (token == null) {
                return true;
            }
            if (token.getStringToken().indexOf(123) != -1 || token.getStringToken().indexOf(125) != -1) {
                this.addToken(token);
                return true;
            }
            token = Check_SVTB_1_5_3.this.getWSParser().getPrevToken(token, this.parserPath);
            if (token.getStringToken().indexOf(123) != -1) {
                this.addToken(token);
                return true;
            }
            token = Check_SVTB_1_5_3.this.getWSParser().getTokenContainingOffset(operator.getCloseBoundary(), this.parserPath);
            if (token == null) {
                return true;
            }
            if (token.getStringToken().indexOf(123) != -1 || token.getStringToken().indexOf(125) != -1) {
                this.addToken(token);
                return true;
            }
            return true;
        }

        private void addToken(LiteralToken token) {
            if (Check_SVTB_1_5_3.this.concatOrAssignTokens.get(this.parserPath) == null) {
                Check_SVTB_1_5_3.this.concatOrAssignTokens.put(this.parserPath, new HashSet());
            }
            Check_SVTB_1_5_3.this.concatOrAssignTokens.get(this.parserPath).add(token);
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

