/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="19.1.48")
@CheckID(value="SVTB.1.7")
@CheckName(value="SVTB.1.7")
@CheckLabel(labels={RuleLabel.STYLING})
@CheckTitle(value="Use specified tokens for vertical alignment")
@CheckDescription(value="All tokens specified in 'verticalAlignmentTokens' on consecutive lines should be vertically aligned.\n\nExamples when verticalAlignmentTokens is '=' :\nc = a + b + a;\nc = 125; // allowed\n  c = a + b;  // not allowed\n    c = a + b;  // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_1_7
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of tokens that will be checked.", name="verticalAlignmentTokens", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pVerticalAlignmentTokens;

    public Check_SVTB_1_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pVerticalAlignmentTokens.isEmpty()) {
            return;
        }
        BufferedReader reader = null;
        List<ParserPath> projectFiles = this.fOVMProject.getAllFilesInOrder();
        if (projectFiles == null || projectFiles.isEmpty()) {
            return;
        }
        for (ParserPath parserPath : projectFiles) {
            block49: {
                block48: {
                    if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
                    if (parserPath.path.indexOf("__vlog__") == -1) break block48;
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.fOVMProject.notifyCheckException(this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    continue;
                }
                RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
                if (filedef != null) break block49;
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                continue;
            }
            try {
                this.notifyCheckAlive();
                reader = new BufferedReader(new FileReader(parserPath.path));
                int currentChar = reader.read();
                CommentStatus commentStatus = CommentStatus.NO_COMMENT;
                StringStatus stringStatus = StringStatus.NO_STRING;
                ArrayList prevLineSpacesCount = new ArrayList();
                ArrayList prevLineTabCount = new ArrayList();
                ArrayList<Integer> spacesCount = new ArrayList<Integer>();
                ArrayList<Integer> tabCount = new ArrayList<Integer>();
                HashMap tokenStartPrev = new HashMap();
                HashMap tokenStartCurrent = new HashMap();
                StringBuilder prevWord = new StringBuilder();
                int relativeOffset = 1;
                int lineNumber = 1;
                char current = (char)currentChar;
                spacesCount.add(0);
                tabCount.add(0);
                if (current == '\n') {
                    ++lineNumber;
                }
                while ((currentChar = reader.read()) != -1) {
                    char prev = current;
                    current = (char)currentChar;
                    if (stringStatus == StringStatus.NO_STRING) {
                        switch (commentStatus) {
                            case NO_COMMENT: {
                                if (prev == '/' && current == '*') {
                                    commentStatus = CommentStatus.MULTILINE_COMMENT;
                                }
                                if (prev != '/' || current != '/') break;
                                commentStatus = CommentStatus.SINGLE_LINE_COMMENT;
                                break;
                            }
                            case SINGLE_LINE_COMMENT: {
                                if (current != '\n' && current != '\r') break;
                                commentStatus = CommentStatus.NO_COMMENT;
                                break;
                            }
                            case MULTILINE_COMMENT: {
                                if (prev != '*' || current != '/') break;
                                commentStatus = CommentStatus.NO_COMMENT;
                            }
                        }
                    }
                    if (commentStatus == CommentStatus.NO_COMMENT) {
                        switch (stringStatus) {
                            case NO_STRING: {
                                if (prev != '\"') break;
                                stringStatus = StringStatus.IN_STRING;
                                break;
                            }
                            case IN_STRING: {
                                if (prev != '\"') break;
                                stringStatus = StringStatus.NO_STRING;
                            }
                        }
                    }
                    int prevNumberOfTabs = (Integer)tabCount.get(tabCount.size() - 1);
                    int prevNumberOfSpaces = (Integer)spacesCount.get(spacesCount.size() - 1);
                    if (current == '\t') {
                        tabCount.add(prevNumberOfTabs + 1);
                        spacesCount.add(prevNumberOfSpaces);
                    } else {
                        tabCount.add(prevNumberOfTabs);
                        spacesCount.add(prevNumberOfSpaces + 1);
                    }
                    if (Character.isWhitespace(prev)) {
                        String prevWordAsString = prevWord.toString();
                        prevWord = new StringBuilder();
                        if (this.pVerticalAlignmentTokens.contains(prevWordAsString) && commentStatus == CommentStatus.NO_COMMENT && stringStatus == StringStatus.NO_STRING) {
                            tokenStartCurrent.putIfAbsent(prevWordAsString, new ArrayList());
                            ((List)tokenStartCurrent.get(prevWordAsString)).add(relativeOffset);
                            List prevLineTokenPosition = (List)tokenStartPrev.get(prevWordAsString);
                            if (prevLineTokenPosition != null && prevLineTokenPosition.contains(relativeOffset)) {
                                int tabCountCurrent = (Integer)tabCount.get(relativeOffset - 1);
                                int tabCountPrev = (Integer)prevLineTabCount.get(relativeOffset - 1);
                                int spaceCountCurrent = (Integer)spacesCount.get(relativeOffset - 1);
                                int spaceCountPrev = (Integer)prevLineSpacesCount.get(relativeOffset - 1);
                                if (tabCountCurrent != tabCountPrev || spaceCountCurrent != spaceCountPrev) {
                                    this.addHit(parserPath, lineNumber, "Token " + prevWordAsString + " is not aligned with the corresponding token on the previous line!", null);
                                }
                            } else if (prevLineTokenPosition != null && ((List)tokenStartPrev.get(prevWordAsString)).size() == ((List)tokenStartCurrent.get(prevWordAsString)).size()) {
                                this.addHit(parserPath, lineNumber, "Token " + prevWordAsString + " is not aligned with the corresponding token on the previous line!", null);
                            }
                        }
                    } else {
                        prevWord.append(prev);
                    }
                    ++relativeOffset;
                    if ((current != '\n' || prev == '\r') && current != '\r') continue;
                    prevLineSpacesCount = new ArrayList(spacesCount);
                    prevLineTabCount = new ArrayList(tabCount);
                    tokenStartPrev = new HashMap(tokenStartCurrent);
                    spacesCount.clear();
                    tabCount.clear();
                    tabCount.add(0);
                    spacesCount.add(0);
                    tokenStartCurrent.clear();
                    relativeOffset = 1;
                    ++lineNumber;
                }
            }
            catch (FileNotFoundException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    this.fOVMProject.notifyCheckException(this, e2);
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e3) {
                            this.fOVMProject.notifyCheckException(this, e3);
                            DVTLogger.INSTANCE.logError((Throwable)e3);
                        }
                    }
                }
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static enum CommentStatus {
        NO_COMMENT,
        SINGLE_LINE_COMMENT,
        MULTILINE_COMMENT;

    }

    private static enum StringStatus {
        NO_STRING,
        IN_STRING;

    }
}

