/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_8;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMaxHitsPerFileCheck;

@CheckVersion(value="20.1.1")
@CheckID(value="SVTB.1.8")
@CheckName(value="SVTB.1.8")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.FILE})
@CheckTitle(value="Files must contain only printable characters")
@CheckDescription(value="Files should contain only printable characters to ensure maximum portability. Line feed (LF) is allowed as line ending.\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", defaultValue="-1"), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
@CheckAutofix(value=Autofix_SVTB_1_8.class)
public class Check_SVTB_1_8
extends AbstractMaxHitsPerFileCheck {
    @CheckParameter(defaultValue="", description="Comma separated list with hex value(e.g. 0x20AC) of Unicode characters.", name="allowedCharacters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedCharacters;
    private Set<Integer> allowedCharacters;

    public Check_SVTB_1_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        this.allowedCharacters = new HashSet<Integer>();
        for (String allowedNonPrintableChar : this.pAllowedCharacters) {
            if (!allowedNonPrintableChar.startsWith("0x")) {
                this.signalParamError("'" + allowedNonPrintableChar + "' is not a valid hex value!", true);
            }
            int hexValue = 0;
            try {
                hexValue = Integer.parseInt(allowedNonPrintableChar.substring(2), 16);
            }
            catch (Exception exception) {
                this.signalParamError("'" + allowedNonPrintableChar + "' is not a valid hex value!", true);
            }
            this.allowedCharacters.add(hexValue);
        }
    }

    @Override
    public void performCheckImpl() {
        BufferedReader reader = null;
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        HashSet<ParserPath> checkedFiles = new HashSet<ParserPath>();
        boolean hasAllowedCharacters = this.pAllowedCharacters != null && !this.pAllowedCharacters.isEmpty();
        for (ParserPath parserPath : files) {
            if (checkedFiles.contains(parserPath)) continue;
            checkedFiles.add(parserPath);
            if (parserPath.path.indexOf("__vlog__") != -1 || this.checkPreWaivers(parserPath)) continue;
            this.notifyCheckAlive();
            int hitCounterPerFile = 0;
            try {
                int c;
                reader = new BufferedReader(new FileReader(parserPath.path));
                int line = 1;
                int offsetInLine = 0;
                while ((c = reader.read()) != -1) {
                    if (!this.reachedMaxHitCountInFile(hitCounterPerFile)) {
                        OVMComplianceHit hit;
                        ++offsetInLine;
                        if (c == 10) {
                            ++line;
                            offsetInLine = 0;
                        }
                        if (this.isNewLine(c) || this.isPrintable(c) || hasAllowedCharacters && this.allowedCharacters.contains(c) || (hit = this.addHit(parserPath, line, this.getMessage(offsetInLine, c), null, false, new VerissimoAutofixAdditionalInfo(line, offsetInLine), this.isHidden(hitCounterPerFile))) == null) continue;
                        ++hitCounterPerFile;
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    this.fOVMProject.notifyCheckException(this, e2);
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e3) {
                            this.fOVMProject.notifyCheckException(this, e3);
                            DVTLogger.INSTANCE.logError((Throwable)e3);
                        }
                    }
                }
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private String getMessage(int offset, int character) {
        if (character == 0) {
            return "NULL character found at offset " + offset + "!";
        }
        return "Character '" + (char)character + "' (" + character + ")  found at line offset " + offset + "!";
    }

    private boolean isPrintable(int c) {
        return c >= 32 && c < 127;
    }

    private boolean isNewLine(int c) {
        return c == 10;
    }
}

