/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_1_9;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFormattingDisabledCheck;

@CheckVersion(value="20.1.26")
@CheckID(value="SVTB.1.9")
@CheckName(value="SVTB.1.9")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.FILE})
@CheckTitle(value="Source files should end with a blank line")
@CheckDescription(value="This rule checks that source files are ended with a blank line\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
@CheckAutofix(value=Autofix_SVTB_1_9.class)
public class Check_SVTB_1_9
extends AbstractFormattingDisabledCheck {
    private static final String ERROR_MESSAGE = "No newline found at end of file. Source files should end with a blank line!";

    public Check_SVTB_1_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.fOVMProject.getAllImportedFiles();
        BufferedReader reader = null;
        int lastCharacter = 0;
        int lineIndex = 1;
        for (ParserPath parserPath : parserPaths) {
            lineIndex = 1;
            this.notifyCheckAlive();
            if (parserPath == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            try {
                int code;
                Boolean isDosLineEnding = false;
                reader = new BufferedReader(new FileReader(parserPath.path));
                while ((code = reader.read()) != -1) {
                    if ((char)code == '\n') {
                        ++lineIndex;
                    }
                    if ((char)code == '\n' && lastCharacter == 13) {
                        isDosLineEnding = true;
                    }
                    lastCharacter = (char)code;
                }
                if (lastCharacter != 10) {
                    this.addHit(parserPath, lineIndex, ERROR_MESSAGE, null, new VerissimoAutofixAdditionalInfo(isDosLineEnding));
                }
            }
            catch (FileNotFoundException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    this.fOVMProject.notifyCheckException(this, e2);
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e3) {
                            this.fOVMProject.notifyCheckException(this, e3);
                            DVTLogger.INSTANCE.logError((Throwable)e3);
                        }
                    }
                }
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

