/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.DataDeclarationChecker;
import ro.amiq.vlogdt.linter.svtb.IDataDeclarationCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.20.11.1")
@CheckName(value="SVTB.20.11.1")
@CheckLabel(labels={RuleLabel.INTERFACE, RuleLabel.MODPORT})
@CheckTitle(value="Virtual interfaces must be declared using a modport")
@CheckDescription(value="The modport enforces direction and the clock sampling relationship. SystemVerilog allows the data declaration of a virtual interface without a modport. This exposes all of the defined signals in the interface without direction or clocking enforcement. \n\nDon't do this. When a virtual interface is defined with a modport only the modport members can be accessed.\n\nExample:\nvirtual my_bus_if.bfm_mp my_bus_mp; // Virtual interface to the bfm modport of my bus interface")
public class Check_SVTB_20_11_1
extends OVMComplianceCheck
implements IDataDeclarationCheck {
    public Check_SVTB_20_11_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        DataDeclarationChecker checker = new DataDeclarationChecker(this.fOVMProject, this);
        checker.visit();
    }

    @Override
    public void notifyPerformCheck(RfField aField) {
        IRfNamedElement assocType = aField.getAssociatedType();
        if (assocType != null && assocType instanceof RfInterface) {
            this.addHit(aField, "Interface '" + ((RfInterface)assocType).getFullName() + "' is not accessed through modport via '" + aField.getName() + "'!");
        }
    }

    @Override
    public void notifyCheckIsAlive() {
        this.notifyCheckAlive();
    }
}

