/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.20.15")
@CheckName(value="SVTB.20.15")
@CheckLabel(labels={RuleLabel.INTERFACE, RuleLabel.ASSIGNMENT, RuleLabel.DESIGN})
@CheckTitle(value="Assignments to interface members must be non-blocking")
@CheckDescription(value="An assignment to an interface member must be a non-blocking assignment.\nThis check skips dynamic type interface members as they cannot be on the left side of a non-blocking assignment.\nThis avoids any race conditions that occur when non-blocking and blocking assignments are used.\nExamples:\n - Not Allowed: m_my_bus_bfm_mp.a_signal = 1'b1;\n - Allowed: m_my_bus_bfm_mp.a_signal <= 1'b1;\n\nCheck supports pre-waiving.")
public class Check_SVTB_20_15
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, only blocking assignments to interface ports are flagged.", name="checkOnlyInterfacePorts", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyInterfacePortsValue;
    @CheckParameter(defaultValue="false", description="When true, blocking assignments within initial blocks are skipped.", name="skipInitialBlocks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipInitialBlocksValue;
    @CheckParameter(defaultValue="false", description="When true, blocking assignments within combinational blocks are skipped.", name="skipCombinationalBlocks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCombinationalBlocksValue;

    public Check_SVTB_20_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidOperator>(){
            private RfNamedElement scope;
            private ParserPath parserPath;

            public boolean visit(IHidOperator hidOp) {
                if (Check_SVTB_20_15.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfNamedElement enclosingScope = this.scope;
                while (enclosingScope != null) {
                    if (enclosingScope instanceof RfFunction && ((RfFunction)enclosingScope).isFunction()) {
                        return true;
                    }
                    if (Check_SVTB_20_15.this.pSkipInitialBlocksValue && enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isInitial()) {
                        return true;
                    }
                    if (Check_SVTB_20_15.this.pSkipCombinationalBlocksValue && enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isCombinational()) {
                        return true;
                    }
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
                HidOperatorOccurrence oc = hidOp.getOccurrence();
                if (!oc.hasQualifier(HidOperatorQualifier.IS_BLOCKING_ASSIGN) && !hidOp.isIncrementOrDecrement()) {
                    return true;
                }
                Check_SVTB_20_15.this.notifyCheckAlive();
                IHidObject lhValue = ((RfHidOperator)hidOp).getLHValue();
                while (lhValue instanceof RfHidAccess) {
                    lhValue = ((RfHidAccess)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                if (!Check_SVTB_20_15.this.isDeclaredInsideInterface((RfHid)lhValue)) {
                    return true;
                }
                if (this.isDynamicType(lhValue)) {
                    return true;
                }
                if (!Check_SVTB_20_15.this.pCheckOnlyInterfacePortsValue) {
                    Check_SVTB_20_15.this.addHit(this.parserPath, (HidOccurrence)((RfHidOperator)hidOp).getOccurrence(), "Blocking assignment to an interface member!");
                    return true;
                }
                IRfNamedElement element = ((RfHid)lhValue).getElement();
                if (!(element instanceof RfField)) {
                    return true;
                }
                if (!(element instanceof RfModport) && !(element instanceof RfPort)) {
                    return true;
                }
                Check_SVTB_20_15.this.addHit(this.parserPath, (HidOccurrence)((RfHidOperator)hidOp).getOccurrence(), "Blocking assignment to an interface member!");
                return true;
            }

            private boolean isDynamicType(IHidObject lhValue) {
                IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)lhValue);
                if (resolvedElement == null) {
                    return false;
                }
                IRfNamedElement asocType = Check_SVTB_20_15.this.getAssociatedType(resolvedElement);
                if (RfListType.isNotFixedArray((IRfScopeElement)asocType)) {
                    return true;
                }
                return asocType instanceof RfPredefinedScalarType && "string".equals(asocType.getName());
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidOperator> getType() {
                return IHidOperator.class;
            }
        });
    }

    private boolean isDeclaredInsideInterface(RfHid hid) {
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (element instanceof RfInterface) {
            return true;
        }
        if (!(element instanceof RfNamedElement)) {
            return false;
        }
        RfNamedElement declaration = ((RfNamedElement)element).getEnclosingScope();
        if (declaration instanceof RfInterface) {
            return true;
        }
        Hid parentHid = hid.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return false;
        }
        return this.isDeclaredInsideInterface((RfHid)hid.getParentHid());
    }

    protected IRfNamedElement getAssociatedType(IRfNamedElement element) {
        if (element == null) {
            return null;
        }
        IRfNamedElement associatedType = null;
        if (element instanceof RfField) {
            associatedType = ((RfField)element).getAssociatedType();
        } else if (element instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)element).getAssociatedType();
        }
        while (associatedType instanceof RfTypeAlias) {
            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
        }
        return associatedType;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

