/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="17.1.2")
@CheckID(value="SVTB.20.16")
@CheckName(value="SVTB.20.16")
@CheckLabel(labels={RuleLabel.INTERFACE, RuleLabel.SIGNAL, RuleLabel.DESIGN})
@CheckTitle(value="Define all interface signals as logic except bidirectional buses")
@CheckDescription(value="Define all interface signals as logic except bidirectional buses\n\nExamples:\n\ninterface my_int (\n\tinput a, // allowed\n\tinput logic b, // allowed\n\tinput bit c, // not allowed\n\toutput bit d, // not allowed\n\tinout bit e // allowed\n );\nendinterface\n")
public class Check_SVTB_20_16
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true input ports of type bit are not reported.", name="allowInputBitPorts", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInputBitPortsValue;
    @CheckParameter(defaultValue="true", description="When true modports are allowed in interfaces.", name="allowModports", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowModports;
    @CheckParameter(defaultValue="false", description="When true ports of type struct are not reported.", name="allowStructPorts", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowStructPortsValue;

    public Check_SVTB_20_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement element : this.fOVMProject.getAllInterfaces()) {
            if (element == null || !(element instanceof RfInterface)) continue;
            this.notifyCheckAlive();
            RfInterface rfInterface = (RfInterface)element;
            List<? extends IRfNamedElement> signals = rfInterface.getAllSignals();
            this.checkSignals(signals, "");
            List<RfModport> modports = rfInterface.getModportsWithPrefix("", 2, 1);
            if (modports == null || modports.isEmpty()) continue;
            for (RfModport modport : modports) {
                Collection<RfNamedElement> modportMembers;
                if (modport == null || (modportMembers = modport.getMembers()) == null) continue;
                ArrayList<RfModportPort> modportPorts = new ArrayList<RfModportPort>();
                for (RfNamedElement namedElement : modportMembers) {
                    if (!(namedElement instanceof RfModportPort)) continue;
                    modportPorts.add((RfModportPort)namedElement);
                }
                this.checkSignals(modportPorts, " in modport '" + modport.getName() + "'");
            }
            List<RfClockingBlock> clkBlks = rfInterface.getClockingBlocksWithPrefix("", 2, 1);
            if (clkBlks == null || clkBlks.isEmpty()) continue;
            for (RfClockingBlock clkBlk : clkBlks) {
                Collection<RfNamedElement> clkBlkMembers;
                if (clkBlk == null || (clkBlkMembers = clkBlk.getMembers()) == null) continue;
                ArrayList<RfModportPort> clkBlkPorts = new ArrayList<RfModportPort>();
                for (RfNamedElement namedElement : clkBlkMembers) {
                    if (!(namedElement instanceof RfModportPort)) continue;
                    clkBlkPorts.add((RfModportPort)namedElement);
                }
                this.checkSignals(clkBlkPorts, " in clocking block '" + clkBlk.getName() + "'");
            }
        }
    }

    private void checkSignals(List<? extends IRfNamedElement> signals, String inModport) {
        if (signals == null || signals.isEmpty()) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : signals) {
            if (iRfNamedElement == null || !(iRfNamedElement instanceof RfPort)) continue;
            RfPort port = (RfPort)iRfNamedElement;
            RfNamedElement portType = LintUtils.getAssociatedFinalType(port);
            if (portType instanceof RfStruct && ((RfStruct)portType).isEnum()) {
                portType = ((RfStruct)portType).getEnumBaseType();
            }
            if (portType instanceof RfListType) {
                portType = ((RfListType)portType).getAssociatedBaseType();
            }
            if (portType == null || portType.getName() == null || this.pAllowModports && portType instanceof RfModport || this.pAllowStructPortsValue && portType instanceof RfStruct) continue;
            if (portType instanceof RfBitVectorScalarType) {
                portType = ((RfBitVectorScalarType)portType).getScalarWithDefaultSign();
            }
            if (this.pAllowInputBitPortsValue && port.isInput() && portType.getName().equals("bit") || portType.getName().equals("logic") || port.isInout()) continue;
            this.addHit(port, "Interface signal '" + LintUtils.getNamedElementFullName(port) + "' is '" + port.getDirectionString() + " " + this.makeName(portType) + "' instead of 'logic'" + inModport + "!");
        }
    }

    private String makeName(IRfNamedElement portType) {
        if (portType instanceof RfStruct) {
            return ((RfStruct)portType).getAliasName() == null ? LintUtils.getElementKind((RfStruct)portType) : ((RfStruct)portType).getAliasName();
        }
        return portType.getName();
    }
}

