/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.21.1.1")
@CheckName(value="SVTB.21.1.1")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.METHOD})
@CheckTitle(value="Allowed Members in Package Scope")
@CheckDescription(value="Only types like structs, unions, classes or typedefs should be declared in the package scope.\nFunctions or tasks declared in the package scope are static. This isn't typically what the user expects.\n\nImplementation Notes:\n This check iterates over all functions, tasks, variables, covergroups and checkers in the package scope.\n DPI imports/exports are allowed.\n\nExamples:\n\npackage my_pkg;\n\ttypedef struct { int a;} my_struct; // allowed\n\t\n\tfunction void foo(); // not allowed\n\tendfunction\nendpackage\n")
@CheckReapplyDisable
public class Check_SVTB_21_1_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="", name="allowConstVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowConstVariablesValue;
    @CheckParameter(defaultValue="false", description="", name="allowCovergroups", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowCovergoupsValue;
    @CheckParameter(defaultValue="false", description="", name="allowCheckers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowCheckersValue;

    public Check_SVTB_21_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfPackage aPackage : this.fOVMProject.getAllPackages()) {
            this.notifyCheckAlive();
            this.checkNamedElement(aPackage.getLocalFields(), "variable");
            this.checkNamedElement(aPackage.getLocalFunctions(), "function");
            this.checkNamedElement(aPackage.getLocalTasks(), "task");
            if (!this.pAllowCovergoupsValue) {
                this.checkNamedElement(aPackage.getLocalMembers(RfCovergroup.class), "covegroup");
            }
            if (this.pAllowCheckersValue) continue;
            this.checkNamedElement(aPackage.getLocalMembers(RfChecker.class), "checker");
        }
    }

    private boolean checkNamedElement(Collection<? extends RfNamedElement> packageElements, String name) {
        boolean anyFailure = false;
        if (packageElements == null || packageElements.isEmpty()) {
            return anyFailure;
        }
        for (RfNamedElement rfNamedElement : packageElements) {
            if (rfNamedElement instanceof RfFunction && (((RfFunction)rfNamedElement).isImportDPI() || ((RfFunction)rfNamedElement).isExportDPI()) || this.pAllowConstVariablesValue && rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isConst()) continue;
            String elemName = name;
            if (rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isNet()) {
                elemName = "net";
            }
            this.addHit(rfNamedElement, "'" + rfNamedElement.getName() + "' " + elemName + " is declared in the package space");
            anyFailure = true;
        }
        return anyFailure;
    }
}

