/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractPackageImportCheck;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;

@CheckVersion(value="15.1.9")
@CheckID(value="SVTB.21.5")
@CheckName(value="SVTB.21.5")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.IMPORT})
@CheckTitle(value="Do not use wildcard imports")
@CheckDescription(value="Wildcard imports pollute the namespace and should be avoided. See https://www.youtube.com/watch?v=cj5xeaopTQQ .\n\nExample:\n   import my_pkg::*; // Not allowed\n   import uvm_pkg::*; // Allowed by default\n\nCheck supports pre-waiving.")
public class Check_SVTB_21_5
extends AbstractPackageImportCheck {
    public Check_SVTB_21_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean skipImportType(ImportInfo importInfo) {
        return importInfo instanceof ExplicitImportInfo;
    }

    @Override
    protected String getErrorMessage(ImportInfo importInfo) {
        return "Not allowed wildcard import '" + importInfo.getPackageName() + "::*'!";
    }
}

