/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.21.6")
@CheckName(value="SVTB.21.6")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.IMPORT})
@CheckTitle(value="Do not use import at compilation unit scope")
@CheckDescription(value="Do not use import at compilation unit scope because doing so would make any imported types visible across all namespaces.\n\nExamples:\n\npackage A;\nendpackage\n\npackage B;\n\timport A::*; // allowed\nendpackage\n\nimport A::*; // not allowed, import in global scope\n\nCheck supports pre-waiving.")
public class Check_SVTB_21_6
extends OVMComplianceCheck {
    public Check_SVTB_21_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        Collection<RfNamedElement> members = rfProject.getMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfNamedElement member : members) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(member.getFile())) continue;
            NullProtectedList<ImportInfo> allImportDeclarations = member.getAllImportDeclarations();
            for (ImportInfo importInfo : allImportDeclarations) {
                if (importInfo.getParserPath() == null) continue;
                this.addHit(importInfo.getParserPath(), importInfo.getLine(), "Import '" + importInfo.getResolvedName() + "' in global scope!", null);
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

