/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="18.1.27")
@CheckID(value="SVTB.22.2")
@CheckName(value="SVTB.22.2")
@CheckLabel(labels={RuleLabel.GENERATE})
@CheckTitle(value="Do not use explicit generate blocks")
@CheckDescription(value="Do not use explicit generate blocks.\nAll tools should support now implicit generate blocks, therefore using generate / endgenerate is not required anymore.\n\nExamples:\n\nmodule top;\n\tbit [7:0] a;\n\n\tgenerate // not allowed\n\t\tassign a = 1;\n\tendgenerate\n\n\tgenvar j;\n\tfor (j = 1; j < 3; j++) begin // allowed\n\tend\nendmodule\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_22_2
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_22_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(8);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Explicit generate block found!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(8);
        HashMap<ParserPath, List<SVTBIssues>> result = new HashMap<ParserPath, List<SVTBIssues>>();
        if (allIssues == null || allIssues.isEmpty()) {
            return result;
        }
        for (Map.Entry<ParserPath, List<SVTBIssues>> entrySet : allIssues.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entrySet.getKey();
            if (this.checkPreWaivers(parserPath) || (issues = entrySet.getValue()) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredIssues = (ArrayList<SVTBIssues>)result.get(parserPath);
            if (filteredIssues == null) {
                filteredIssues = new ArrayList<SVTBIssues>();
                result.put(parserPath, filteredIssues);
            }
            for (SVTBIssues issue : issues) {
                if (issue.getCarry() != 1) continue;
                filteredIssues.add(issue);
            }
        }
        return result;
    }
}

