/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.23.1")
@CheckName(value="SVTB.23.1")
@CheckLabel(labels={RuleLabel.DPI})
@CheckTitle(value="DPI is deprecated, use DPI-C instead")
@CheckDescription(value="The dpi_spec_string DPI is deprecated and should be replaced with 'DPI-C'.Use of the DPI-C string may require changes in the DPI application's C code.\n\nCheck supports pre-waiving.")
public class Check_SVTB_23_1
extends OVMComplianceCheck {
    public Check_SVTB_23_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement method : allMethods) {
            RfFunction rfFunction;
            String methodName;
            this.notifyCheckAlive();
            if (method == null || !(method instanceof RfFunction) || this.checkPreWaivers(method.getFile()) || (methodName = method.getName()) == null || !(rfFunction = (RfFunction)method).isDPI()) continue;
            String dpiKind = null;
            dpiKind = rfFunction.isImportDPI() ? rfFunction.getImportDPIKind() : rfFunction.getExportDPIKind();
            if (dpiKind != null) {
                dpiKind = dpiKind.trim();
            }
            if (!"DPI".equals(dpiKind)) continue;
            this.addHit(method, "The dpi_spec_string 'DPI' is deprecated and should be replaced with 'DPI-C' for '" + methodName + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

