/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.23.2")
@CheckName(value="SVTB.23.2")
@CheckLabel(labels={RuleLabel.DPI, RuleLabel.METHOD, RuleLabel.NAME})
@CheckTitle(value="DPI C identifier must be equal with method name")
@CheckDescription(value="The C identifier should be the same with the SystemVerilog identifier for DPI methods.")
public class Check_SVTB_23_2
extends OVMComplianceCheck {
    public Check_SVTB_23_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement method : allMethods) {
            String cMethodName;
            RfFunction rfFunction;
            String methodName;
            this.notifyCheckAlive();
            if (method == null || !(method instanceof RfFunction) || (methodName = method.getName()) == null || !(rfFunction = (RfFunction)method).isDPI() || (cMethodName = rfFunction.getCIdentifier()) == null || methodName.equals(cMethodName)) continue;
            this.addHit(method, "The C identifier is not equal with the SystemVerilog identifier for '" + methodName + "'!");
        }
    }
}

