/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_25_10;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.25.10")
@CheckName(value="SVTB.25.10")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Argument files comment style")
@CheckDescription(value="Always use <commentStyle> comments in argument files.\n\nExamples:\n// allowed\n# not allowed\n-- not allowed\n-f .dvt/included1.f\n\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_25_10.class)
public class Check_SVTB_25_10
extends OVMComplianceCheck {
    private static final Set<String> COMMENT_STYLES = new HashSet<String>();
    @CheckParameter(defaultValue="//", description="One of '//', '--', '#'.", name="commentStyle", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pCommentStyleValue;

    static {
        COMMENT_STYLES.add("//");
        COMMENT_STYLES.add("--");
        COMMENT_STYLES.add("#");
    }

    public Check_SVTB_25_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pCommentStyleValue == null) {
            this.pCommentStyleValue = "//";
        }
        if (!COMMENT_STYLES.contains(this.pCommentStyleValue)) {
            this.signalParamError("Parameter 'commentStyle' value is not one of '//', '--', '#'!", false);
            return;
        }
        List argFiles = BuildConfigManager.getIncludeProperties((IProject)this.fOVMProject.getProject());
        if (argFiles.isEmpty()) {
            return;
        }
        for (BuildConfigProperty argFile : argFiles) {
            this.notifyCheckAlive();
            Object attribute = argFile.getAttribute("ATTRIBUTE_COMMENT_LINES_LIST");
            if (attribute == null || !(attribute instanceof Map)) continue;
            Map map = (Map)attribute;
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals(this.pCommentStyleValue)) continue;
                for (Integer line : (ArrayList)entry.getValue()) {
                    this.addHit(new ParserPath(argFile.getValue()), (int)line, "Comment style '" + (String)entry.getKey() + "' is used in argument file!", null, new VerissimoAutofixAdditionalInfo(entry.getKey()));
                }
            }
        }
    }
}

