/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="17.1.26")
@CheckID(value="SVTB.25.11")
@CheckName(value="SVTB.25.11")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.MACRO})
@CheckTitle(value="Do not use // comments in macro definitions using line continuation.")
@CheckDescription(value="Do not use // comments in macro definitions using line continuation.\n\nExamples:\n`define D // first comment (NOT allowed)\n\tfunction void XX(); // second comment (NOT allowed) \\\n\t\t$display(\"HELLO\"); // third comment (NOT allowed) \\\n\tendfunction // last comment (allowed)\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_25_11
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_25_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(133);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Single line comments are not allowed!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(133);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.getSVTBIssues();
        block0: for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            ParserPath file = entry.getKey();
            if (this.checkPreWaivers(file)) continue;
            int hitCounterPerFile = 0;
            List<SVTBIssues> issues = entry.getValue();
            if (issues == null) continue;
            this.notifyCheckAlive();
            for (SVTBIssues issue : issues) {
                int line = issue.getLine() - 1;
                this.addHit(file, line, this.getFailMessage(issue), issue.getReparseInfo());
                if (this.pMaxHitsPerFileValue != -1 && ++hitCounterPerFile >= this.pMaxHitsPerFileValue) continue block0;
            }
        }
    }
}

