/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="18.1.35")
@CheckID(value="SVTB.25.12")
@CheckName(value="SVTB.25.12")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Task tags comment pattern")
@CheckDescription(value="All comment lines starting with the specified <taskTags> (case insensitive) must be matched by <taskTagCommentPattern>.\nIn case of single line comments, the pattern will be applied on the full commnent line starting with //, for example: '// TODO: ...'\nIn case of multiline comments, the pattern will be applied as follows:\n - for the 1st line, it will be applied starting with /*, for example: '/* TODO: ...'\n - for the next lines, it will be applied on the full line starting with the first character on that line, for example: '        * TODO: ...'\n - for the last line, it will be applied on the full line ending with */, for example: '        * TODO: ... */'\n\nExamples with taskTagCommentPattern='// TODO:\\s+\\w+':\n// TODO: mod_1 // allowed\n// TODO1: mod_2 // not allowed\n/* todo: prm1 */ // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_25_12
extends OVMComplianceCheck {
    private static final String HIT_MESSAGE = "The task tag comment line does not match the specified pattern!";
    private static final String NEW_LINE_REGEX = "\\R";
    private static final String DELIMETER_REGEX = "\\W";
    private Matcher commentMatcher;
    @CheckParameter(defaultValue="todo", description="Comma separated list of task tags (case insensitive). Comment lines starting with these task tags will be checked using the <taskTagCommentPattern>.", name="taskTags", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pTaskTags;
    @CheckParameter(defaultValue="^//\\sTODO:.*$", description="Regular expression that validates the comment lines containing <taskTags>.", name="taskTagCommentPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pTaskCommentPattern;

    public Check_SVTB_25_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(136);
    }

    @Override
    public void performCheckImpl() {
        if (this.pTaskTags == null || this.pTaskTags.isEmpty() || this.pTaskCommentPattern == null) {
            return;
        }
        this.commentMatcher = this.pTaskCommentPattern.matcher("");
        this.pTaskTags = this.getUpperCaseTaskTags(this.pTaskTags);
        Map<ParserPath, List<SVTBIssues>> commentCharIssuesMap = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 136, this);
        if (commentCharIssuesMap == null || commentCharIssuesMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : commentCharIssuesMap.entrySet()) {
            ParserPath file = entry.getKey();
            List<SVTBIssues> issues = entry.getValue();
            if (issues == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            for (SVTBIssues issue : issues) {
                String[] commentLines;
                String commentString = issue.getInfo();
                if (commentString == null || (commentLines = commentString.split(NEW_LINE_REGEX)) == null || commentLines.length == 0) continue;
                int currentLine = 0;
                String[] stringArray = commentLines;
                int n = commentLines.length;
                int n2 = 0;
                while (n2 < n) {
                    String taskTagToken;
                    String[] commentLineTokens;
                    String commentLine = stringArray[n2];
                    ++currentLine;
                    String trimmedComment = commentLine.trim();
                    if (!trimmedComment.isEmpty() && (commentLineTokens = trimmedComment.split(DELIMETER_REGEX)) != null && commentLineTokens.length != 0 && (taskTagToken = this.firstNonWhiteSpaceToken(commentLineTokens)) != null && this.isInTaskTags(taskTagToken.toUpperCase())) {
                        this.commentMatcher.reset(commentLine);
                        if (!this.commentMatcher.matches()) {
                            this.addHit(file, issue.getLine() + currentLine - 1, HIT_MESSAGE, issue.getReparseInfo());
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private HashSet<String> getUpperCaseTaskTags(HashSet<String> taskTags) {
        if (taskTags == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String taskTag : taskTags) {
            result.add(taskTag.toUpperCase());
        }
        return result;
    }

    private boolean isInTaskTags(String tag) {
        for (String taskTag : this.pTaskTags) {
            if (!tag.startsWith(taskTag)) continue;
            return true;
        }
        return false;
    }

    private String firstNonWhiteSpaceToken(String[] commentTokens) {
        if (commentTokens == null || commentTokens.length == 0) {
            return null;
        }
        int i = 0;
        while (i < commentTokens.length) {
            if (!commentTokens[i].trim().isEmpty()) {
                return commentTokens[i];
            }
            ++i;
        }
        return null;
    }
}

