/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="19.1.50")
@CheckID(value="SVTB.25.13")
@CheckName(value="SVTB.25.13")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Do not use multiline comments")
@CheckDescription(value="Do not use multiline comments so that the files can be easily parsed using regular expressions.\n\nExamples:\n/* multiline comment */ // not allowed\n// single line comment // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_25_13
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="Allow multiline comments caused by linter pragma waivers.", name="allowPragmaWaivers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowPragmaWaivers;
    private static final Pattern PRAGMA_WAIVER_PATTERN = Pattern.compile("\\s*@DVT_LINTER_WAIVER");
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus;

    public Check_SVTB_25_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performCheckImpl() {
        reader = null;
        allFiles = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath parserPath : allFiles) {
            block44: {
                block43: {
                    if (parserPath.path.indexOf("__vlog__") != -1) continue;
                    this.notifyCheckAlive();
                    if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
                    reader = new BufferedReader(new FileReader(parserPath.path));
                    line = 1;
                    commentStatus = CommentStatus.NO_COMMENT;
                    stringStatus = StringStatus.NO_STRING;
                    relativeOffset = 0;
                    c = reader.read();
                    if (c != -1) break block43;
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.fOVMProject.notifyCheckException(this, e);
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    continue;
                }
                current = (char)c;
                ++relativeOffset;
                if (current == '\n') {
                    ++line;
                    relativeOffset = 0;
                }
                if (current != '\r') ** GOTO lbl49
                prev = current;
                c = reader.read();
                if (c != -1) break block44;
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                continue;
            }
            try {
                current = (char)c;
                if (current == '\n') {
                    ++line;
                    relativeOffset = 0;
                }
lbl49:
                // 10 sources

                block31: while ((c = reader.read()) != -1) {
                    prev = current;
                    current = (char)c;
                    ++relativeOffset;
                    if (current == '\r' || current == '\n' && prev != '\r') {
                        ++line;
                        relativeOffset = 0;
                    } else if (current == '\n' && prev == '\r') {
                        relativeOffset = 0;
                    }
                    switch (Check_SVTB_25_13.$SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus()[stringStatus.ordinal()]) {
                        case 1: {
                            if (commentStatus != CommentStatus.NO_COMMENT || current != '\"') break;
                            stringStatus = StringStatus.IN_STRING;
                            break;
                        }
                        case 2: {
                            if (prev == '\\' || current != '\"') break;
                            stringStatus = StringStatus.NO_STRING;
                        }
                    }
                    if (stringStatus != StringStatus.NO_STRING) continue;
                    switch (Check_SVTB_25_13.$SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus()[commentStatus.ordinal()]) {
                        case 1: {
                            if (prev == '/' && current == '*') {
                                commentStartOffset = relativeOffset;
                                isEndOfLine = current == '\r' || current == '\n' && prev != '\r';
                                v0 = isEndOfComment = prev == '*' && current == '/';
                                if (this.pAllowPragmaWaivers) {
                                    comment = new StringBuilder();
                                    comment.append(prev);
                                    comment.append(current);
                                    while (!isEndOfLine && !isEndOfComment && (c = reader.read()) != -1) {
                                        prev = current;
                                        current = (char)c;
                                        ++relativeOffset;
                                        comment.append(current);
                                        isEndOfLine = current == '\r' || current == '\n' && prev != '\r';
                                        v1 = isEndOfComment = prev == '*' && current == '/';
                                    }
                                    if (Check_SVTB_25_13.isPragmaWaiver(comment)) continue block31;
                                }
                                if (!isEndOfComment) {
                                    commentStatus = CommentStatus.MULTILINE_COMMENT;
                                }
                                this.addHit(parserPath, line, "Multiline comment found at line offset " + (commentStartOffset - 1) + "!", null);
                                if (isEndOfLine) {
                                    ++line;
                                    relativeOffset = 0;
                                }
                            }
                            if (prev != '/' || current != '/') continue block31;
                            commentStatus = CommentStatus.SINGLE_LINE_COMMENT;
                            break;
                        }
                        case 3: {
                            if (current != '\r' && (current != '\n' || prev == '\r')) continue block31;
                            commentStatus = CommentStatus.NO_COMMENT;
                            break;
                        }
                        case 2: {
                            if (prev != '*' || current != '/') continue block31;
                            commentStatus = CommentStatus.NO_COMMENT;
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    continue;
                }
                catch (Throwable var16_25) {
                    throw var16_25;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            this.fOVMProject.notifyCheckException(this, e);
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static boolean isPragmaWaiver(StringBuilder comment) {
        Matcher matcher = PRAGMA_WAIVER_PATTERN.matcher(comment.toString());
        return matcher.find();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus() {
        if ($SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus != null) {
            return $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus;
        }
        int[] nArray = new int[StringStatus.values().length];
        try {
            nArray[StringStatus.IN_STRING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StringStatus.NO_STRING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$StringStatus = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus() {
        if ($SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus != null) {
            return $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus;
        }
        int[] nArray = new int[CommentStatus.values().length];
        try {
            nArray[CommentStatus.MULTILINE_COMMENT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommentStatus.NO_COMMENT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommentStatus.SINGLE_LINE_COMMENT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ro$amiq$vlogdt$linter$svtb$Check_SVTB_25_13$CommentStatus = nArray;
        return nArray;
    }

    static enum CommentStatus {
        NO_COMMENT,
        MULTILINE_COMMENT,
        SINGLE_LINE_COMMENT;

    }

    static enum StringStatus {
        NO_STRING,
        IN_STRING;

    }
}

