/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="20.1.32")
@CheckID(value="SVTB.25.14")
@CheckName(value="SVTB.25.14")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.METHOD})
@CheckTitle(value="Comment consistency for functions and tasks")
@CheckDescription(value="This rule checks the consistency and position of comments for functions and tasks.\nComments consistency can be enforced for the entire project or per file.\n\nCheck supports pre-waiving.")
public class Check_SVTB_25_14
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="both", description="Comma separated list of: declaration, implementation, both. Specify where comments should be for the entire project.\nUse declaration and implementation to check that the comment is on at least one of the two.", name="commentPosition", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCommentPositions;
    @CheckParameter(defaultValue="false", description="When true the comment consistency will be enforced on each file independently.", name="consistencyPerFile", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pConsistencyPerFile;
    private Map<ParserPath, FunctionComments> fFunctionCommentsInFiles = null;

    public Check_SVTB_25_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String pCommentPosition : this.pCommentPositions) {
            if (pCommentPosition.equalsIgnoreCase("both") || pCommentPosition.equalsIgnoreCase("declaration") || pCommentPosition.equalsIgnoreCase("implementation")) continue;
            this.signalParamError("'" + pCommentPosition + "' is not a valid position for the comment block!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (this.pConsistencyPerFile) {
            this.fFunctionCommentsInFiles = new HashMap<ParserPath, FunctionComments>();
        }
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfFunction functionElement;
                Check_SVTB_25_14.this.notifyCheckAlive();
                if (namedElement instanceof RfFunction && !(functionElement = (RfFunction)namedElement).isPredefined()) {
                    if (Check_SVTB_25_14.this.checkPreWaivers(namedElement)) {
                        return true;
                    }
                    Check_SVTB_25_14.this.analyzeFunction(functionElement);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
        if (this.pConsistencyPerFile) {
            this.checkConsistency();
            this.fFunctionCommentsInFiles.clear();
        }
    }

    public boolean checkPreWaivers(RfNamedElement namedElement) {
        if (namedElement == null || namedElement.getFile() == null || namedElement.getFile().getParserPath() == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(namedElement.getFile().getParserPath(), this);
    }

    private void checkConsistency() {
        block5: for (Map.Entry<ParserPath, FunctionComments> entry : this.fFunctionCommentsInFiles.entrySet()) {
            ParserPath path = entry.getKey();
            FunctionComments functionComments = entry.getValue();
            CommentPosType mostFrequentCommType = functionComments.getMostFrequentCommType();
            switch (mostFrequentCommType) {
                case BOTH: {
                    for (RfFunction elem : functionComments.getNone()) {
                        this.addHit(path, elem.getDeclaration().getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments both on the declaration and the implementation!", null);
                        this.addHit(path, elem.getImplementation().getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments both on the declaration and the implementation!", null);
                    }
                    for (RfFunction elem : functionComments.getDeclarationOnly()) {
                        this.addHit(path, elem.getImplementation().getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments both on the declaration and the implementation!", null);
                    }
                    for (RfFunction elem : functionComments.getImplementationOnly()) {
                        this.addHit(path, elem.getDeclaration().getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments both on the declaration and the implementation!", null);
                    }
                    continue block5;
                }
                case DECLARATION: {
                    for (RfFunction elem : functionComments.getNone()) {
                        this.addHit(path, elem.getDeclaration().getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments on the declaration!", null);
                    }
                    for (RfFunction elem : functionComments.getImplementationOnly()) {
                        this.addHit(path, elem.getDeclaration().getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments on the declaration!", null);
                    }
                    continue block5;
                }
                case IMPLEMENTATION: {
                    for (RfFunction elem : functionComments.getNone()) {
                        this.addHit(path, elem.getImplementation().getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments on the implementation!", null);
                    }
                    for (RfFunction elem : functionComments.getDeclarationOnly()) {
                        this.addHit(path, elem.getImplementation().getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(elem) + "' should have a comment because most functions in this file have comments on the implementation!", null);
                    }
                    continue block5;
                }
            }
        }
    }

    private boolean hasComment(RfDefElement elem) {
        if (elem.getCommentBlock() == null) {
            return false;
        }
        CommentBlock comment = elem.getCommentBlock();
        return !comment.getAboveComment().isEmpty() || !comment.getInlineComment().isEmpty();
    }

    private void analyzeFunction(RfFunction functionElement) {
        this.notifyCheckAlive();
        if (functionElement == null) {
            return;
        }
        RfDefElement declaration = functionElement.getDeclaration();
        RfDefElement implementation = functionElement.getImplementation();
        if (declaration == null || declaration.getReparseInfo() != null) {
            return;
        }
        if (implementation == null || implementation.getReparseInfo() != null) {
            return;
        }
        boolean commentInDeclaration = this.hasComment(declaration);
        boolean commentInImplementation = this.hasComment(implementation);
        if (this.pConsistencyPerFile) {
            this.collectData(functionElement, declaration, implementation, commentInDeclaration, commentInImplementation);
            return;
        }
        if (this.pCommentPositions.contains("declaration") && this.pCommentPositions.contains("implementation")) {
            if (!commentInDeclaration && !commentInImplementation) {
                this.addHit(declaration.getParserPath(), declaration.getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
                this.addHit(implementation.getParserPath(), implementation.getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
            }
        } else if (this.pCommentPositions.contains("declaration")) {
            if (!commentInDeclaration) {
                this.addHit(declaration.getParserPath(), declaration.getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
            }
        } else if (this.pCommentPositions.contains("implementation")) {
            if (!commentInImplementation) {
                this.addHit(implementation.getParserPath(), implementation.getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
            }
        } else if (this.pCommentPositions.contains("both")) {
            if (!commentInDeclaration) {
                this.addHit(declaration.getParserPath(), declaration.getStartLine(), "Declaration of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
            }
            if (!commentInImplementation) {
                this.addHit(implementation.getParserPath(), implementation.getStartLine(), "Implementation of '" + LintUtils.getNamedElementFullName(functionElement) + "' should have a comment!", null);
            }
        }
    }

    private void collectData(RfFunction functionElement, RfDefElement declaration, RfDefElement implementation, boolean commentInDeclaration, boolean commentInImplementation) {
        if (!declaration.getParserPath().equals((Object)implementation.getParserPath())) {
            this.addHit(declaration.getParserPath(), declaration.getStartLine(), "Declaration and implementation of '" + LintUtils.getNamedElementFullName(functionElement) + "' are not in the same file!", null);
            this.addHit(implementation.getParserPath(), implementation.getStartLine(), "Declaration and implementation of '" + LintUtils.getNamedElementFullName(functionElement) + "' are not in the same file!", null);
            return;
        }
        ParserPath path = declaration.getParserPath();
        if (this.fFunctionCommentsInFiles.get(path) == null) {
            this.fFunctionCommentsInFiles.put(path, new FunctionComments());
        }
        FunctionComments functionComments = this.fFunctionCommentsInFiles.get(path);
        if (commentInDeclaration && commentInImplementation) {
            functionComments.addBoth(functionElement);
        } else if (commentInDeclaration) {
            functionComments.addDeclarationOnly(functionElement);
        } else if (commentInImplementation) {
            functionComments.addImplementationOnly(functionElement);
        } else {
            functionComments.addNone(functionElement);
        }
    }

    static enum CommentPosType {
        NONE,
        DECLARATION,
        IMPLEMENTATION,
        BOTH;

    }

    static class FunctionComments {
        private List<RfFunction> commentBoth = new LinkedList<RfFunction>();
        private List<RfFunction> commentDeclaration = new LinkedList<RfFunction>();
        private List<RfFunction> commentImplementation = new LinkedList<RfFunction>();
        private List<RfFunction> commentNone = new LinkedList<RfFunction>();

        public void addNone(RfFunction functionElement) {
            this.commentNone.add(functionElement);
        }

        public List<RfFunction> getNone() {
            return this.commentNone;
        }

        public void addImplementationOnly(RfFunction functionElement) {
            this.commentImplementation.add(functionElement);
        }

        public List<RfFunction> getImplementationOnly() {
            return this.commentImplementation;
        }

        public void addDeclarationOnly(RfFunction functionElement) {
            this.commentDeclaration.add(functionElement);
        }

        public List<RfFunction> getDeclarationOnly() {
            return this.commentDeclaration;
        }

        public void addBoth(RfFunction functionElement) {
            this.commentBoth.add(functionElement);
        }

        public List<RfFunction> getBoth() {
            return this.commentBoth;
        }

        public CommentPosType getMostFrequentCommType() {
            int bothCount = this.commentBoth.size();
            int declarationCount = this.commentDeclaration.size();
            int implementationCount = this.commentImplementation.size();
            if (bothCount >= declarationCount && bothCount >= implementationCount) {
                return CommentPosType.BOTH;
            }
            if (declarationCount >= bothCount && declarationCount >= implementationCount) {
                return CommentPosType.DECLARATION;
            }
            if (implementationCount >= bothCount && implementationCount >= declarationCount) {
                return CommentPosType.IMPLEMENTATION;
            }
            return CommentPosType.DECLARATION;
        }
    }
}

