/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCommentCheck;
import ro.amiq.vlogdt.linter.svtb.CITElementsVisitor;
import ro.amiq.vlogdt.linter.svtb.ICITElementsVisitorImpl;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.25.4.0")
@CheckName(value="SVTB.25.4.0")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Element comment")
@CheckDescription(value="All <elementKind>s  must have a comment, optionally <mandatoryInline>, <mandatoryAbove>.\n\nExamples with default values (elementKind='class'):\n// Utility class\nclass utility_class; // allowed\n\t...\nendclass\n\nclass no_comment_class; // not allowed\n\t...\nendclass\n")
public class Check_SVTB_25_4_0
extends AbstractCommentCheck
implements ICITElementsVisitorImpl {
    @CheckParameter(defaultValue="class", description="Comma separated list of package, module, class, interface, struct, union, enum, typedef, clocking, modport, covergroup, function, task. typedef enum is enum, similar for struct, union.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue;
    @CheckParameter(defaultValue="false", description="If type aliases (typedefs) to elementKind should follow the elementKind comment pattern. Applicable only for targets class, interface, modport.", name="checkTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckTypedefsValue;
    @CheckParameter(defaultValue="", description="Relevant when checking typedefs. Comma separated list of enum, struct, union, class, interface, modport.", name="skipIfTypedefTo", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipIfTypedefToValue;
    @CheckParameter(defaultValue="false", description="If a comment must be on the line above.", name="mandatoryInline", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryInlineValue;
    @CheckParameter(defaultValue="false", description="", name="mandatoryAbove", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryAboveValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipElementsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipElementsDeclaredInsideMacrosWithPrefixes;
    @CheckParameter(defaultValue="", description="Define the pattern of the comment.", name="commentPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pCommentPattern;
    private Matcher matcher;
    private Set<String> allowedKindValues = new HashSet<String>(Arrays.asList("package", "class", "module", "interface", "struct", "union", "enum", "typedef", "clocking", "modport", "covergroup", "function", "task"));

    public Check_SVTB_25_4_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (!this.allowedKindValues.containsAll(this.pElementKindValue)) {
            this.signalParamError("Invalid value: " + this.pElementKindValue + " for 'elementKind'!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        if (!this.pCommentPattern.pattern().isEmpty()) {
            this.matcher = this.pCommentPattern.matcher("");
        }
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty()) {
            return;
        }
        for (String elementKindValue : this.pElementKindValue) {
            new CITElementsVisitor(this.fOVMProject, this, elementKindValue, this.pCheckTypedefsValue, false, this.pSkipIfTypedefToValue, this.pSkipElementsDeclaredInsideMacrosWithPrefixes, false, null).visit();
        }
    }

    @Override
    public void visitCITElement(RfNamedElement aRfNamedElement, String aHitPrefix, boolean isOfElementKind) {
        RfDefElement implementation;
        this.notifyCheckAlive();
        if (aRfNamedElement == null) {
            return;
        }
        String namedElementComment = aRfNamedElement.getRawComment();
        String implementationComment = null;
        CommentBlock implementationCommentBlock = null;
        if (aRfNamedElement instanceof RfFunction && aRfNamedElement.isExtern() && (implementation = aRfNamedElement.getImplementation()) != null) {
            implementationComment = implementation.getRawDefComment();
            implementationCommentBlock = implementation.getCommentBlock();
        }
        if ((namedElementComment == null || namedElementComment.isEmpty()) && (implementationComment == null || implementationComment.isEmpty())) {
            this.addHit(aRfNamedElement, String.valueOf(aHitPrefix.substring(0, 1).toUpperCase()) + aHitPrefix.substring(1) + "doesn't have a comment!");
            return;
        }
        CommentBlock commentBlock = aRfNamedElement.getCommentBlock();
        if (commentBlock == null && implementationCommentBlock == null) {
            return;
        }
        String inlineComment = null;
        String implementationInlineComment = null;
        if (commentBlock != null) {
            inlineComment = commentBlock.getRawInlineComment();
        }
        if (implementationCommentBlock != null) {
            implementationInlineComment = implementationCommentBlock.getRawInlineComment();
        }
        if (this.pMandatoryInlineValue && (inlineComment == null || inlineComment.isEmpty()) && (implementationInlineComment == null || implementationInlineComment.isEmpty())) {
            this.addHit(aRfNamedElement, String.valueOf(aHitPrefix.substring(0, 1).toUpperCase()) + aHitPrefix.substring(1) + "doesn't have a comment inline!");
            return;
        }
        String aboveComment = null;
        String implementationAboveComment = null;
        if (commentBlock != null) {
            aboveComment = commentBlock.getRawAboveComment();
        }
        if (implementationCommentBlock != null) {
            implementationAboveComment = implementationCommentBlock.getRawAboveComment();
        }
        if (this.pMandatoryAboveValue && (aboveComment == null || aboveComment.isEmpty()) && (implementationAboveComment == null || implementationAboveComment.isEmpty())) {
            this.addHit(aRfNamedElement, String.valueOf(aHitPrefix.substring(0, 1).toUpperCase()) + aHitPrefix.substring(1) + "doesn't have a comment above!");
            return;
        }
        if (this.matcher == null) {
            return;
        }
        boolean matched = false;
        if (namedElementComment != null) {
            this.matcher.reset(namedElementComment);
            if (this.matcher.matches()) {
                matched = true;
            }
        }
        if (!matched && implementationComment != null) {
            this.matcher.reset(implementationComment);
            if (this.matcher.matches()) {
                matched = true;
            }
        }
        if (!matched) {
            this.addHit(aRfNamedElement, "The comment of " + aHitPrefix + "does not match the specified pattern!");
        }
    }
}

