/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCommentCheck;
import ro.amiq.vlogdt.linter.svtb.CITElementsVisitor;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.svtb.ICITElementsVisitorImpl;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="18.1.30")
@CheckID(value="SVTB.25.4.1")
@CheckName(value="SVTB.25.4.1")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Element comment style")
@CheckDescription(value="Always use <commentStyle> style for <elementKind>s.\n\nExamples with default values (commentStyle='//' and elementKind='class'):\n// Utility class\nclass utility_class; // allowed\n\t...\nendclass\n\nclass no_comment_class; // not allowed\n\t...\nendclass\n")
public class Check_SVTB_25_4_1
extends AbstractCommentCheck
implements ICITElementsVisitorImpl {
    @CheckParameter(defaultValue="class", description="Comma separated list of package, module, class, interface, struct, union, enum, typedef, clocking, modport, covergroup, enum item,field, constructor, constructor_extern_implementation, function, function_extern_implementation, task, task_extern_implementation, constraint, constraint_extern_implementation, event, covergroup.Typedef enum is enum, similar for struct, union.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue;
    @CheckParameter(defaultValue="//", description="Comma separated list of comment styles. One or many of '//', '/*', '/**'.", name="commentStyle", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCommentStyle;
    private static Set<String> possibleClassMembers = new HashSet<String>();
    private static Set<String> possibleNonClassElements = new HashSet<String>();
    private Set<String> allowedKindValues = new HashSet<String>(Arrays.asList("package", "class", "module", "interface", "struct", "union", "enum", "typedef", "clocking", "modport", "covergroup", "field", "enum item", "constructor", "constructor_extern_implementation", "function", "function_extern_implementation", "task", "task_extern_implementation", "constraint", "constraint_extern_implementation", "event"));

    static {
        possibleClassMembers.add("field");
        possibleClassMembers.add("constructor");
        possibleClassMembers.add("constructor_extern_implementation");
        possibleClassMembers.add("function");
        possibleClassMembers.add("function_extern_implementation");
        possibleClassMembers.add("task");
        possibleClassMembers.add("task_extern_implementation");
        possibleClassMembers.add("constraint");
        possibleClassMembers.add("constraint_extern_implementation");
        possibleClassMembers.add("event");
        possibleNonClassElements.add("package");
        possibleNonClassElements.add("module");
        possibleNonClassElements.add("class");
        possibleNonClassElements.add("interface");
        possibleNonClassElements.add("struct");
        possibleNonClassElements.add("union");
        possibleNonClassElements.add("enum");
        possibleNonClassElements.add("typedef");
        possibleNonClassElements.add("clocking");
        possibleNonClassElements.add("modport");
        possibleNonClassElements.add("covergroup");
        possibleNonClassElements.add("enum item");
    }

    public Check_SVTB_25_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (!this.allowedKindValues.containsAll(this.pElementKindValue)) {
            this.signalParamError("Invalid value: " + this.pElementKindValue + " for 'elementKind'!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty()) {
            return;
        }
        HashSet<String> classMembers = new HashSet<String>();
        HashSet<String> nonClassMembers = new HashSet<String>();
        for (String elementKind : this.pElementKindValue) {
            if (possibleClassMembers.contains(elementKind)) {
                classMembers.add(elementKind);
                continue;
            }
            if (!possibleNonClassElements.contains(elementKind)) continue;
            nonClassMembers.add(elementKind);
        }
        if (!nonClassMembers.isEmpty()) {
            this.checkNonClassMembers(nonClassMembers);
        }
        if (!classMembers.isEmpty()) {
            this.checkClassMembers(classMembers);
        }
    }

    private void checkNonClassMembers(HashSet<String> nonClassMembers) {
        HashSet<String> emptyHashSet = new HashSet<String>();
        for (String elementKind : nonClassMembers) {
            new CITElementsVisitor(this.fOVMProject, this, elementKind, false, false, emptyHashSet, emptyHashSet, false, null).visit();
        }
    }

    private void checkClassMembers(HashSet<String> classMembers) {
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, classMembers, true);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName();
                List<RfDefElement> definitionsToCheck = this.getDefinitionsToCheck(eachMember, classMembers);
                if (definitionsToCheck.isEmpty()) continue;
                for (RfDefElement definition : definitionsToCheck) {
                    String inlineCommentStyle;
                    String aboveCommentStyle;
                    String commentString = definition.getRawDefComment();
                    if (commentString == null || commentString.isEmpty()) {
                        this.addHit(definition.getParserPath(), definition.getStartLine(), "Class member '" + memberInfo + "' doesn't have a comment!", definition.getReparseInfo());
                        continue;
                    }
                    CommentBlock commentBlock = definition.getCommentBlock();
                    if (commentBlock == null) continue;
                    String aboveComment = commentBlock.getRawAboveComment();
                    if (aboveComment != null && !aboveComment.isEmpty() && !this.pCommentStyle.contains(aboveCommentStyle = this.getCommentStyle(commentBlock.getAboveCommentStyle()))) {
                        this.addHit(definition.getParserPath(), definition.getStartLine(), "Above comment style '" + aboveCommentStyle + "' used for comment of class member '" + memberInfo + "'!", definition.getReparseInfo());
                        continue;
                    }
                    String inlineComment = commentBlock.getRawInlineComment();
                    if (inlineComment == null || inlineComment.isEmpty() || this.pCommentStyle.contains(inlineCommentStyle = this.getCommentStyle(commentBlock.getInlineCommentStyle()))) continue;
                    this.addHit(definition.getParserPath(), definition.getStartLine(), "Inline comment style '" + inlineCommentStyle + "' used for comment of class member '" + memberInfo + "'!", definition.getReparseInfo());
                }
            }
        }
    }

    @Override
    public void visitCITElement(RfNamedElement aRfNamedElement, String aHitPrefix, boolean isOfElementKind) {
        String inlineCommentStyle;
        String aboveCommentStyle;
        this.notifyCheckAlive();
        if (aRfNamedElement == null) {
            return;
        }
        String namedElementComment = aRfNamedElement.getRawComment();
        if (namedElementComment == null || namedElementComment.isEmpty()) {
            this.addHit(aRfNamedElement, String.valueOf(aHitPrefix.substring(0, 1).toUpperCase()) + aHitPrefix.substring(1) + "doesn't have a comment!");
            return;
        }
        CommentBlock commentBlock = aRfNamedElement.getCommentBlock();
        if (commentBlock == null) {
            return;
        }
        String aboveComment = commentBlock.getRawAboveComment();
        if (aboveComment != null && !aboveComment.isEmpty() && !this.pCommentStyle.contains(aboveCommentStyle = this.getCommentStyle(commentBlock.getAboveCommentStyle()))) {
            this.addHit(aRfNamedElement, "Above comment style '" + aboveCommentStyle + "' used for comment of " + aHitPrefix.trim() + "!");
            return;
        }
        String inlineComment = commentBlock.getRawInlineComment();
        if (inlineComment != null && !inlineComment.isEmpty() && !this.pCommentStyle.contains(inlineCommentStyle = this.getCommentStyle(commentBlock.getInlineCommentStyle()))) {
            this.addHit(aRfNamedElement, "Inline comment style '" + inlineCommentStyle + "' used for comment of " + aHitPrefix.trim() + "!");
            return;
        }
    }

    public String getCommentStyle(Comment.CommentStyle commentStyle) {
        switch (commentStyle) {
            case SL_KIND: {
                return "//";
            }
            case ML_KIND: {
                return "/*";
            }
            case ML2_KIND: {
                return "/**";
            }
        }
        return "";
    }
}

