/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.25.6.6")
@CheckName(value="SVTB.25.6.6")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.CLASS})
@CheckTitle(value="Class properties inline comment")
@CheckDescription(value="All class member variables (properties) must be commented with a single inline comment.\nExample:\nint files_open; // number of open files")
public class Check_SVTB_25_6_6
extends OVMComplianceCheck {
    public Check_SVTB_25_6_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement aClass : this.fOVMProject.getAllNonXVMClasses()) {
            List<RfField> fields;
            this.notifyCheckAlive();
            if (aClass == null || (fields = aClass.getLocalFields()) == null) continue;
            for (RfField field : fields) {
                String inlineComment;
                if (field == null || field.isFromEmbeddedCovergroupDef()) continue;
                if (field.getComment().isEmpty()) {
                    this.addHit(field, "Member variable '" + field.getName() + "' doesn't have a comment!");
                    continue;
                }
                CommentBlock commentBlock = field.getCommentBlock();
                if (commentBlock == null || (inlineComment = commentBlock.getInlineComment()) != null && !inlineComment.isEmpty()) continue;
                this.addHit(field, "Member variable '" + field.getName() + "' doesn't have an inline comment!");
            }
        }
    }
}

