/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCommentCheck;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.25.6.6.0")
@CheckName(value="SVTB.25.6.6.0")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.FIELD})
@CheckTitle(value="Class members comment")
@CheckDescription(value="All <memberKinds> class members must have a comment, optionally <mandatoryInline>, <mandatoryAbove>.\n\nExamples:\nclass a;\n\tint field_a; // not allowed\n\n\tfunction void foo(); // not allowed\n\tendfunction\nendclass\n\nclass b;\n\t// Field field_b doc\n\tint field_b; // allowed\n\n\t// Function bar doc\n\tfunction void bar(); // allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_25_6_6_0
extends AbstractCommentCheck {
    @CheckParameter(defaultValue="field, function, task, constraint, event, covergroup", description="Comma separated list of field, constructor, constructor_extern_implementation, function, function_extern_implementation, task, task_extern_implementation, constraint, constraint_extern_implementation, event, covergroup. For external member kinds, to enforce this rule on the prototype, use constructor/function/task/constraint. To enforce this rule on the implementation, use constructor_extern_implementation/function_extern_implementation/task_extern_implementation/constraint_extern_implementation.", name="memberKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pMemberKindsValue;
    @CheckParameter(defaultValue="false", description="Boolean, if a comment must be on the same line.", name="mandatoryInline", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryInlineValue;
    @CheckParameter(defaultValue="false", description="Boolean, if a comment must be on the line above.", name="mandatoryAbove", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryAboveValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMembersDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMembersDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideClassesWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Define the pattern of the comment.", name="commentPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pCommentPattern;
    @CheckParameter(defaultValue="", description="Comma separated list of element name patterns to be skipped.", name="skipNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipNamePatterns;

    public Check_SVTB_25_6_6_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Matcher matcher = null;
        if (!this.pCommentPattern.pattern().isEmpty()) {
            matcher = this.pCommentPattern.matcher("");
        }
        HashSet<Matcher> skipNameMatchers = new HashSet<Matcher>();
        for (Pattern skipNamePatternMatch : this.pSkipNamePatterns) {
            if (skipNamePatternMatch.pattern() == null || skipNamePatternMatch.pattern().isEmpty()) continue;
            skipNameMatchers.add(skipNamePatternMatch.matcher(""));
        }
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, this.pMemberKindsValue, true, this.pSkipMembersDeclaredInsideMacrosWithPrefixesValue, this.pSkipMembersDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null || eachMember.getFile() == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(eachMember.getFile().getParserPath(), this)) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName();
                List<RfDefElement> definitionsToCheck = this.getDefinitionsToCheck(eachMember, this.pMemberKindsValue);
                if (definitionsToCheck.isEmpty()) continue;
                block3: for (RfDefElement definition : definitionsToCheck) {
                    if (!skipNameMatchers.isEmpty()) {
                        for (Matcher matcher2 : skipNameMatchers) {
                            if (matcher2 == null) continue;
                            matcher2.reset(definition.getName());
                            if (matcher2.matches()) continue block3;
                        }
                    }
                    if (definition instanceof RfFieldDef var11_13 && var11_13.getParentDef() instanceof RfCovergroupDef) continue;
                    String commentString = definition.getRawDefComment();
                    if (commentString == null || commentString.isEmpty()) {
                        this.addHit(definition.getParserPath(), definition.getStartLine(), "Class member '" + memberInfo + "' doesn't have a comment!", definition.getReparseInfo());
                        continue;
                    }
                    CommentBlock commentBlock = definition.getCommentBlock();
                    if (commentBlock == null) continue;
                    String inlineComment = commentBlock.getRawInlineComment();
                    if (this.pMandatoryInlineValue && (inlineComment == null || inlineComment.isEmpty())) {
                        this.addHit(definition.getParserPath(), definition.getStartLine(), "Class member '" + memberInfo + "' doesn't have a comment inline!", definition.getReparseInfo());
                        continue;
                    }
                    String aboveComment = commentBlock.getRawAboveComment();
                    if (this.pMandatoryAboveValue && (aboveComment == null || aboveComment.isEmpty())) {
                        this.addHit(definition.getParserPath(), definition.getStartLine(), "Class member '" + memberInfo + "' doesn't have a comment above!", definition.getReparseInfo());
                        continue;
                    }
                    if (matcher == null) continue;
                    matcher.reset(commentString);
                    if (matcher.matches()) continue;
                    this.addHit(definition.getParserPath(), definition.getStartLine(), "The comment of class member '" + memberInfo + "' does not match the specified pattern!", definition.getReparseInfo());
                }
            }
        }
    }
}

