/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.25.6.7.0")
@CheckName(value="SVTB.25.6.7.0")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Class method arguments comment")
@CheckDescription(value="All class method arguments must have a comment.\n\nExamples:\nclass a;\n\tfunction void foo(int a, int b); // not allowed\n\tendfunction\n\n\tfunction void bar( // allowed\n\t\t/* argument a */ int a, // allowed\n\t\t/* argument b */ int b  // allowed\n\t);\n\tendfunction\nendclass\n")
public class Check_SVTB_25_6_7_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of constructor, function, task. Default all.", name="memberKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pMemberKindsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMethodsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMethodsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMethodsDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMethodsDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_25_6_7_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMemberKindsValue.isEmpty()) {
            this.pMemberKindsValue.add("constructor");
            this.pMemberKindsValue.add("function");
            this.pMemberKindsValue.add("task");
        }
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, this.pMemberKindsValue, true, this.pSkipMethodsDeclaredInsideMacrosWithPrefixesValue, this.pSkipMethodsDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName() + "()";
                List<RfField> arguments = eachMember.getArgumentsWithPrefix("", 2);
                if (arguments == null || arguments.isEmpty()) continue;
                for (RfField argument : arguments) {
                    if (argument == null || argument.getComment() != null && !argument.getComment().isEmpty()) continue;
                    this.addHit(argument, "Argument '" + argument.getName() + "' of '" + memberInfo + "' doesn't have a comment!");
                }
            }
        }
    }
}

