/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBannedIdentifierCheck;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="17.1.16")
@CheckID(value="SVTB.25.9")
@CheckName(value="SVTB.25.9")
@CheckLabel(labels={RuleLabel.COMMENT})
@CheckTitle(value="Banned comments content")
@CheckDescription(value="Fails when any of the <commentPatterns> match inside the comments.\n\nExamples for commentPatterns='comment\\d':\n/* a simple comment which is allowed */\n// comment1 is not allowed\n/* comment7 is not allowed too */\n\nCheck supports pre-waiving.")
public class Check_SVTB_25_9
extends AbstractBannedIdentifierCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of patterns.", name="commentPatterns", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pCommentPatternsValue;

    public Check_SVTB_25_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(136);
    }

    @Override
    public void performCheckImpl() {
        if (this.pCommentPatternsValue == null || this.pCommentPatternsValue.isEmpty()) {
            return;
        }
        this.checkComments(this.pCommentPatternsValue);
    }
}

